/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.filters.basic;

import java.io.IOException;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import net.codestory.http.filters.Filter;
import net.codestory.http.filters.PayloadSupplier;
import net.codestory.http.internal.Context;
import net.codestory.http.payload.Payload;

public class BasicAuthFilter
implements Filter {
    private final String uriPrefix;
    private final String realm;
    private final Map<String, String> usersPerHash;

    public BasicAuthFilter(String uriPrefix, String realm, Map<String, String> users) {
        this.uriPrefix = uriPrefix;
        this.realm = realm;
        this.usersPerHash = new HashMap<String, String>();
        users.entrySet().forEach(entry -> {
            String user = (String)entry.getKey();
            String password = (String)entry.getValue();
            String hash = Base64.getEncoder().encodeToString((user + ":" + password).getBytes());
            this.usersPerHash.put("Basic " + hash, user);
        });
    }

    @Override
    public Payload apply(String uri, Context context, PayloadSupplier nextFilter) throws IOException {
        if (!uri.startsWith(this.uriPrefix)) {
            return nextFilter.get();
        }
        String authorizationHeader = context.getHeader("Authorization");
        if (authorizationHeader == null) {
            return Payload.unauthorized(this.realm);
        }
        String user = this.usersPerHash.get(authorizationHeader.trim());
        if (user == null) {
            return Payload.unauthorized(this.realm);
        }
        context.setCurrentUser(user);
        return nextFilter.get();
    }
}

