/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.compilers;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import net.codestory.http.io.InputStreams;

abstract class AbstractNashornCompiler {
    private final CompiledScript compiledScript;
    private final Bindings bindings;

    protected AbstractNashornCompiler(String scriptPath) {
        ScriptEngine nashorn = new ScriptEngineManager().getEngineByName("nashorn");
        try (InputStream input = ClassLoader.getSystemResourceAsStream(scriptPath);){
            String script = InputStreams.readString(input, StandardCharsets.UTF_8);
            this.compiledScript = ((Compilable)((Object)nashorn)).compile(this.decorateScript(script));
            this.bindings = nashorn.getBindings(100);
        }
        catch (IOException | ScriptException e) {
            throw new IllegalStateException(e);
        }
    }

    protected abstract void setBindings(Bindings var1, String var2);

    protected abstract String decorateScript(String var1);

    public synchronized String compile(String source) throws IOException {
        this.setBindings(this.bindings, source);
        try {
            return this.compiledScript.eval(this.bindings).toString();
        }
        catch (ScriptException e) {
            throw new IOException("Unable to compile", e);
        }
    }
}

