/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.templating;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.codestory.http.io.Resources;
import net.codestory.http.io.Strings;
import net.codestory.http.templating.YamlParser;

public class YamlFrontMatter {
    private static final String SEPARATOR = "---\n";
    private final String name;
    private final String content;
    private final Map<String, Object> variables;

    private YamlFrontMatter(String name, String content, Map<String, Object> variables) {
        this.name = name;
        this.content = content;
        this.variables = new HashMap<String, Object>(variables);
        this.variables.put("content", content);
    }

    public String getName() {
        return this.name;
    }

    public String getContent() {
        return this.content;
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public static YamlFrontMatter parse(Path path) throws IOException {
        return YamlFrontMatter.parse(path.getFileName().toString(), Resources.read(path, StandardCharsets.UTF_8));
    }

    public static YamlFrontMatter parse(String name, String content) {
        if (Strings.countMatches(content, SEPARATOR) < 2) {
            return new YamlFrontMatter(name, content, Collections.emptyMap());
        }
        return new YamlFrontMatter(name, YamlFrontMatter.stripHeader(content), YamlFrontMatter.parseVariables(content));
    }

    private static String stripHeader(String content) {
        return Strings.substringAfter(Strings.substringAfter(content, SEPARATOR), SEPARATOR);
    }

    private static Map<String, Object> parseVariables(String content) {
        String header = Strings.substringBetween(content, SEPARATOR, SEPARATOR);
        return new YamlParser().parse(header);
    }
}

