/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.compilers;

import com.github.rjeschke.txtmark.Processor;
import com.github.sommeri.less4j.Less4jException;
import com.github.sommeri.less4j.core.ThreadUnsafeLessCompiler;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import net.codestory.http.io.Strings;
import org.jcoffeescript.JCoffeeScriptCompileException;
import org.jcoffeescript.JCoffeeScriptCompiler;
import org.jcoffeescript.Option;

public enum Compiler {
    COFFEE{

        @Override
        String compile(String coffee) throws IOException {
            try {
                return new JCoffeeScriptCompiler(Collections.singletonList(Option.BARE)).compile(coffee);
            }
            catch (JCoffeeScriptCompileException e) {
                throw new IOException("Unable to compile coffee", e);
            }
        }
    }
    ,
    MARKDOWN{

        @Override
        String compile(String markdown) {
            return Processor.process((String)markdown);
        }
    }
    ,
    LESS{

        @Override
        String compile(String less) throws IOException {
            try {
                return new ThreadUnsafeLessCompiler().compile(less).getCss();
            }
            catch (Less4jException e) {
                throw new IOException("Unable to compile less", e);
            }
        }
    }
    ,
    NONE{

        @Override
        String compile(String content) {
            return content;
        }
    };


    abstract String compile(String var1) throws IOException;

    public static String compile(Path path, String content) throws IOException {
        return Compiler.compilerForExtension(Compiler.extension(path)).compile(content);
    }

    private static String extension(Path path) {
        return Strings.substringAfterLast(path.toString(), ".");
    }

    private static Compiler compilerForExtension(String extension) {
        switch (extension) {
            case "less": {
                return LESS;
            }
            case "coffee": {
                return COFFEE;
            }
            case "md": 
            case "markdown": {
                return MARKDOWN;
            }
        }
        return NONE;
    }
}

