/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.misc;

public enum Env {
    INSTANCE;

    private static final String APP_PORT = "app.port";
    private static final String DISABLE_CLASSPATH = "http.disable.classpath";
    private static final String DISABLE_FILESYSTEM = "http.disable.filesystem";
    private static final String PROD_MODE = "PROD_MODE";
    private final boolean prodMode = Env.getBoolean("PROD_MODE", false);
    private final boolean disableClassPath = Env.getBoolean("http.disable.classpath", false);
    private final boolean disableFilesystem = Env.getBoolean("http.disable.filesystem", false);

    public boolean devMode() {
        return !this.prodMode;
    }

    public int overriddenPort(int port) {
        return Env.getInt(APP_PORT, port);
    }

    public boolean disableClassPath() {
        return this.disableClassPath;
    }

    public boolean disableFilesystem() {
        return this.disableFilesystem;
    }

    private static String get(String propertyName) {
        String env = System.getenv(propertyName);
        return env != null ? env : System.getProperty(propertyName);
    }

    private static boolean getBoolean(String propertyName, boolean defaultValue) {
        String value = Env.get(propertyName);
        return value == null ? defaultValue : Boolean.parseBoolean(value);
    }

    private static int getInt(String propertyName, int defaultValue) {
        String value = Env.get(propertyName);
        return value == null ? defaultValue : Integer.parseInt(value);
    }
}

