/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.compilers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import net.codestory.http.compilers.AsciidocCompiler;
import net.codestory.http.compilers.CoffeeCompiler;
import net.codestory.http.compilers.Compiler;
import net.codestory.http.compilers.LessCompiler;
import net.codestory.http.compilers.LessSourceMapCompiler;
import net.codestory.http.compilers.MarkdownCompiler;
import net.codestory.http.io.InputStreams;
import net.codestory.http.misc.MemoizingSupplier;
import net.codestory.http.misc.Sha1;

public enum Compilers {
    INSTANCE;

    private static final String VERSION = "V1";
    private final Map<String, Supplier<? extends Compiler>> compilerByExtension = new HashMap<String, Supplier<? extends Compiler>>();
    private final ConcurrentMap<String, String> cache = new ConcurrentHashMap<String, String>();

    private Compilers() {
        this.register(CoffeeCompiler::new, ".coffee", ".litcoffee");
        this.register(MarkdownCompiler::new, ".md", ".markdown");
        this.register(LessCompiler::new, ".less", new String[0]);
        this.register(LessSourceMapCompiler::new, ".css.map", new String[0]);
        this.register(AsciidocCompiler::new, ".asciidoc", ".adoc");
    }

    public void register(Supplier<? extends Compiler> compilerFactory, String firstExtension, String ... moreExtensions) {
        Supplier<? extends Compiler> compilerLazyFactory = MemoizingSupplier.memoize(compilerFactory);
        this.compilerByExtension.put(firstExtension, compilerLazyFactory);
        for (String extension : moreExtensions) {
            this.compilerByExtension.put(extension, compilerLazyFactory);
        }
    }

    public String compile(Path path, String content) {
        return this.cache.computeIfAbsent(path.toString() + ";" + content, ignore -> this.doCompile(path, content));
    }

    private String doCompile(Path path, String content) {
        String filename = path.toString();
        for (Map.Entry<String, Supplier<? extends Compiler>> entry : this.compilerByExtension.entrySet()) {
            String extension = entry.getKey();
            if (!filename.endsWith(extension)) continue;
            try {
                String sha1 = Sha1.of(content);
                File file = Paths.get(System.getProperty("user.home"), ".code-story", "cache", VERSION, extension.substring(1), sha1).toFile();
                String fromCache = Compilers.readFromCache(file);
                if (fromCache != null) {
                    return fromCache;
                }
                Compiler compiler = entry.getValue().get();
                String compiled = compiler.compile(path, content);
                Compilers.writeToCache(file, compiled);
                return compiled;
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        return content;
    }

    private static String readFromCache(File file) throws IOException {
        if (!file.exists()) {
            return null;
        }
        try (FileInputStream input = new FileInputStream(file);){
            String string = InputStreams.readString(input, StandardCharsets.UTF_8);
            return string;
        }
    }

    private static void writeToCache(File file, String data) throws IOException {
        File parentFile = file.getParentFile();
        if (!parentFile.exists() && !parentFile.mkdirs()) {
            throw new IllegalStateException("Unable to create cache folder: " + parentFile);
        }
        File tmpFile = new File(file.getAbsolutePath() + ".tmp");
        try (FileWriter writer = new FileWriter(file);){
            writer.write(data);
        }
        tmpFile.renameTo(file);
    }
}

