/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.templating;

import com.github.jknack.handlebars.ValueResolver;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.codestory.http.io.Resources;
import net.codestory.http.io.Strings;
import net.codestory.http.misc.Env;
import net.codestory.http.misc.MemoizingSupplier;
import net.codestory.http.templating.YamlFrontMatter;
import net.codestory.http.templating.YamlParser;

public class Site {
    private static Site INSTANCE = new Site();
    private Supplier<Map<String, Object>> yaml = MemoizingSupplier.memoize(() -> this.loadYamlConfig("_config.yml"));
    private Supplier<Map<String, Object>> data = MemoizingSupplier.memoize(() -> Resources.list().stream().filter(string -> string.startsWith("_data/")).collect(Collectors.toMap(string -> Site.nameWithoutExtension(string), string -> Site.readYaml(string))));
    private Supplier<List<Map<String, Object>>> pages = MemoizingSupplier.memoize(() -> Resources.list().stream().filter(string -> !string.startsWith("_")).map(string -> Site.pathToMap(string)).collect(Collectors.toList()));
    private Supplier<Map<String, List<Map<String, Object>>>> tags = MemoizingSupplier.memoize(() -> {
        TreeMap<String, List> treeMap = new TreeMap<String, List>();
        for (Map<String, Object> map : this.getPages()) {
            for (String string2 : Site.tags(map)) {
                treeMap.computeIfAbsent(string2, string -> new ArrayList()).add(map);
            }
        }
        return treeMap;
    });
    private Supplier<Map<String, List<Map<String, Object>>>> categories = MemoizingSupplier.memoize(() -> {
        Map map2 = this.getPages().stream().collect(Collectors.groupingBy(map -> Site.category(map), TreeMap::new, Collectors.toList()));
        return map2;
    });

    private Site() {
    }

    public static Site get() {
        return Env.INSTANCE.devMode() ? new Site() : INSTANCE;
    }

    private Map<String, Object> configYaml() {
        return this.yaml.get();
    }

    public Object get(String key) {
        return this.yaml.get().get(key);
    }

    public Map<String, Object> getData() {
        return this.data.get();
    }

    public List<Map<String, Object>> getPages() {
        return this.pages.get();
    }

    public Map<String, List<Map<String, Object>>> getTags() {
        return this.tags.get();
    }

    public Map<String, List<Map<String, Object>>> getCategories() {
        return this.categories.get();
    }

    private static Map<String, Object> pathToMap(String path) {
        try {
            return YamlFrontMatter.parse(Paths.get(path, new String[0])).getVariables();
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to read file: " + path, e);
        }
    }

    private static Object readYaml(String path) {
        try {
            return YamlParser.INSTANCE.parse(Resources.read(Paths.get(path, new String[0]), StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to read file: " + path, e);
        }
    }

    private static String category(Map<String, Object> page) {
        return page.getOrDefault("category", "").toString().trim();
    }

    private static String[] tags(Map<String, Object> page) {
        return page.getOrDefault("tags", "").toString().trim().split("\\s*,\\s*");
    }

    private Map<String, Object> loadYamlConfig(String configFile) {
        Path configPath = Paths.get(configFile, new String[0]);
        if (!Resources.exists(configPath)) {
            return new HashMap<String, Object>();
        }
        try {
            return YamlParser.INSTANCE.parseMap(Resources.read(configPath, StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to read " + configFile, e);
        }
    }

    private static String nameWithoutExtension(String path) {
        return Strings.substringBeforeLast(Paths.get(path, new String[0]).getFileName().toString(), ".");
    }

    static enum SiteValueResolver implements ValueResolver
    {
        INSTANCE;


        public Object resolve(Object context, String name) {
            if (context instanceof Site) {
                return ((Site)context).configYaml().getOrDefault(name, UNRESOLVED);
            }
            return UNRESOLVED;
        }

        public Set<Map.Entry<String, Object>> propertySet(Object context) {
            if (context instanceof Site) {
                return ((Site)context).configYaml().entrySet();
            }
            return Collections.emptySet();
        }
    }
}

