/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http;

import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.file.Path;
import java.util.Random;
import javax.net.ssl.SSLContext;
import net.codestory.http.Configuration;
import net.codestory.http.errors.ErrorPage;
import net.codestory.http.errors.HttpException;
import net.codestory.http.filters.log.LogRequestFilter;
import net.codestory.http.internal.Context;
import net.codestory.http.misc.Env;
import net.codestory.http.payload.Payload;
import net.codestory.http.reload.RoutesProvider;
import net.codestory.http.routes.RouteCollection;
import net.codestory.http.ssl.SSLContextFactory;
import org.simpleframework.http.Request;
import org.simpleframework.http.Response;
import org.simpleframework.http.core.ContainerServer;
import org.simpleframework.transport.Server;
import org.simpleframework.transport.connect.SocketConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebServer {
    private static final Logger LOG = LoggerFactory.getLogger(WebServer.class);
    private final Server server;
    private final SocketConnection connection;
    private RoutesProvider routesProvider;
    private int port;

    public WebServer() {
        this(routes -> {});
    }

    public WebServer(Configuration configuration) {
        try {
            this.server = new ContainerServer(this::handle);
            this.connection = new SocketConnection(this.server);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to create http server", e);
        }
        this.configure(configuration);
    }

    public static void main(String[] args) throws Exception {
        new WebServer(routes -> routes.filter(new LogRequestFilter())).start(8080);
    }

    public WebServer configure(Configuration configuration) {
        this.routesProvider = this.devMode() ? RoutesProvider.reloading(configuration) : RoutesProvider.fixed(configuration);
        return this;
    }

    public WebServer startOnRandomPort() {
        Random random = new Random();
        for (int i = 0; i < 20; ++i) {
            try {
                int port = 8183 + random.nextInt(1000);
                this.start(port);
                return this;
            }
            catch (Exception e) {
                LOG.error("Unable to bind server", (Throwable)e);
                continue;
            }
        }
        throw new IllegalStateException("Unable to start server");
    }

    public WebServer start(int port) {
        return this.startWithContext(port, null);
    }

    public WebServer startSSL(int port, Path pathCertificate, Path pathPrivateKey) {
        SSLContext context;
        try {
            context = new SSLContextFactory().create(pathCertificate, pathPrivateKey);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to read certificate or key", e);
        }
        return this.startWithContext(port, context);
    }

    private WebServer startWithContext(int port, SSLContext context) {
        try {
            this.port = Env.INSTANCE.overriddenPort(port);
            this.connection.connect((SocketAddress)new InetSocketAddress(this.port), context);
            LOG.info("Server started on port {}", (Object)this.port);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (BindException e) {
            throw new IllegalStateException("Port already in use " + this.port);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to bind the web server on port " + this.port, e);
        }
        return this;
    }

    public int port() {
        return this.port;
    }

    public void reset() {
        this.configure(routes -> {});
    }

    public void stop() {
        try {
            this.server.stop();
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to stop the web server", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handle(Request request, Response response) {
        RouteCollection routes = this.routesProvider.get();
        Context context = new Context(request, response, routes.getIocAdapter());
        try {
            this.applyRoutes(routes, context);
        }
        catch (Exception e) {
            this.handleServerError(context, e);
        }
        finally {
            try {
                response.close();
            }
            catch (IOException e) {}
        }
    }

    protected void applyRoutes(RouteCollection routeCollection, Context context) throws IOException {
        Payload payload = routeCollection.apply(context);
        if (payload.isError()) {
            payload = this.errorPage(payload);
        }
        payload.writeTo(context);
    }

    protected void handleServerError(Context context, Exception e) {
        if (!(e instanceof HttpException)) {
            e.printStackTrace();
        }
        try {
            this.errorPage(e).writeTo(context);
        }
        catch (IOException error) {
            LOG.warn("Unable to serve an error page", (Throwable)error);
        }
    }

    protected Payload errorPage(Payload payload) {
        return this.errorPage(payload, null);
    }

    protected Payload errorPage(Exception e) {
        int code = e instanceof HttpException ? ((HttpException)e).code() : 500;
        return this.errorPage(new Payload(code), e);
    }

    protected Payload errorPage(Payload payload, Exception e) {
        Exception shownError = this.devMode() ? e : null;
        return new ErrorPage(payload, shownError).payload();
    }

    protected boolean devMode() {
        return Env.INSTANCE.devMode();
    }
}

