/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.routes;

import java.nio.file.Path;
import java.util.concurrent.ConcurrentHashMap;
import net.codestory.http.io.Resources;
import net.codestory.http.routes.StaticRoute;

class CachedStaticRoute
extends StaticRoute {
    private final ConcurrentHashMap<String, Path> pathForUri = new ConcurrentHashMap(10);

    CachedStaticRoute() {
    }

    @Override
    protected Path path(String uri) {
        return this.pathForUri.computeIfAbsent(uri, CachedStaticRoute::findPath);
    }

    private static Path findPath(String uri) {
        Path path = Resources.findExistingPath(uri);
        return path != null && Resources.isPublic(path) ? path : NOT_FOUND;
    }
}

