/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.misc;

public class Env {
    private static final String APP_PORT = "app.port";
    private static final String DISABLE_CLASSPATH = "http.disable.classpath";
    private static final String DISABLE_FILESYSTEM = "http.disable.filesystem";
    private static final String PROD_MODE = "PROD_MODE";

    private Env() {
    }

    public static boolean devMode() {
        return Env.getBoolean(PROD_MODE, false);
    }

    public static int overriddenPort(int port) {
        return Env.getInt(APP_PORT, port);
    }

    public static boolean disableClassPath() {
        return Env.getBoolean(DISABLE_CLASSPATH, false);
    }

    public static boolean disableFilesystem() {
        return Env.getBoolean(DISABLE_FILESYSTEM, false);
    }

    private static String get(String propertyName) {
        String env = System.getenv(propertyName);
        return env != null ? env : System.getProperty(propertyName);
    }

    private static boolean getBoolean(String propertyName, boolean defaultValue) {
        String value = Env.get(propertyName);
        return value == null ? defaultValue : Boolean.parseBoolean(value);
    }

    private static int getInt(String propertyName, int defaultValue) {
        String value = Env.get(propertyName);
        return value == null ? defaultValue : Integer.parseInt(value);
    }
}

