/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.convert;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Map;
import net.codestory.http.internal.Context;

public class TypeConvert {
    private static ObjectMapper OBJECT_MAPPER = new ObjectMapper().setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);

    private TypeConvert() {
    }

    public static void overrideMapper(ObjectMapper mapper) {
        OBJECT_MAPPER = mapper;
    }

    public static Object[] convert(Context context, String[] pathParameters, Class<?>[] types) {
        Object[] converted = new Object[pathParameters.length + 1];
        for (int i = 0; i < pathParameters.length; ++i) {
            converted[i] = TypeConvert.fromString(pathParameters[i], types[i]);
        }
        converted[converted.length - 1] = TypeConvert.convert(context, types[converted.length - 1]);
        return converted;
    }

    public static Object[] convert(String[] pathParameters, Class<?>[] types) {
        Object[] converted = new Object[pathParameters.length];
        for (int i = 0; i < pathParameters.length; ++i) {
            converted[i] = TypeConvert.fromString(pathParameters[i], types[i]);
        }
        return converted;
    }

    public static <T> T convert(Context context, Class<T> type) {
        String json;
        if (type.isAssignableFrom(Context.class)) {
            return (T)context;
        }
        if (type.isAssignableFrom(Map.class)) {
            return (T)context.keyValues();
        }
        if (TypeConvert.isUrlEncodedForm(context)) {
            return TypeConvert.fromKeyValues(context.keyValues(), type);
        }
        try {
            json = context.request().getContent();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable read request content", e);
        }
        return TypeConvert.fromJson(json, type);
    }

    public static <T> T fromJson(String json, Class<T> type) {
        try {
            return (T)OBJECT_MAPPER.readValue(json, type);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to parse json", e);
        }
    }

    public static <T> T fromString(String value, Class<T> type) {
        return (T)OBJECT_MAPPER.convertValue((Object)value, type);
    }

    public static <T> T fromKeyValues(Map<String, String> keyValues, Class<T> type) {
        return (T)OBJECT_MAPPER.convertValue(keyValues, type);
    }

    public static byte[] toByteArray(Object value) {
        try {
            return OBJECT_MAPPER.writer().writeValueAsBytes(value);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Unable to serialize to json", e);
        }
    }

    public static String toJson(Object value) {
        try {
            return OBJECT_MAPPER.writer().writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Unable to serialize to json", e);
        }
    }

    private static boolean isUrlEncodedForm(Context context) {
        String contentType = context.getHeader("Content-Type");
        return contentType != null && contentType.contains("application/x-www-form-urlencoded");
    }
}

