/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.compilers;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import org.markdown4j.Plugin;

class FormulaPlugin
extends Plugin {
    public FormulaPlugin() {
        super("formula");
    }

    public void emit(StringBuilder result, List<String> lines, Map<String, String> parameters) {
        String type = parameters.getOrDefault("type", "png");
        lines.forEach(string2 -> {
            if (!string2.trim().isEmpty()) {
                result.append("<img src=\"http://latex.codecogs.com/").append(type).append(".download?").append(FormulaPlugin.encode(string2)).append("\" />");
            }
        });
    }

    private static String encode(String line) {
        try {
            return URLEncoder.encode(line, "US-ASCII").replace("+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            return line;
        }
    }
}

