/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.compilers;

import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import net.codestory.http.compilers.AsciidocCompiler;
import net.codestory.http.compilers.CoffeeCompiler;
import net.codestory.http.compilers.Compiler;
import net.codestory.http.compilers.LessCompiler;
import net.codestory.http.compilers.LessSourceMapCompiler;
import net.codestory.http.compilers.MarkdownCompiler;
import net.codestory.http.misc.MemoizingSupplier;

public enum Compilers {
    INSTANCE;

    private final Map<String, Supplier<? extends Compiler>> compilerByExtension = new HashMap<String, Supplier<? extends Compiler>>();
    private final ConcurrentMap<String, String> cache = new ConcurrentHashMap<String, String>();

    private Compilers() {
        this.register(CoffeeCompiler::new, ".coffee", ".litcoffee");
        this.register(MarkdownCompiler::new, ".md", ".markdown");
        this.register(LessCompiler::new, ".less", new String[0]);
        this.register(LessSourceMapCompiler::new, ".css.map", new String[0]);
        this.register(AsciidocCompiler::new, ".asciidoc", new String[0]);
    }

    public void register(Supplier<? extends Compiler> compilerFactory, String firstExtension, String ... moreExtensions) {
        Supplier<? extends Compiler> compilerLazyFactory = MemoizingSupplier.memoize(compilerFactory);
        this.compilerByExtension.put(firstExtension, compilerLazyFactory);
        for (String extension : moreExtensions) {
            this.compilerByExtension.put(extension, compilerLazyFactory);
        }
    }

    public String compile(Path path, String content) {
        return this.cache.computeIfAbsent(path.toString() + ";" + content, string2 -> {
            try {
                return this.doCompile(path, content);
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        });
    }

    private String doCompile(Path path, String content) throws IOException {
        String filename = path.toString();
        for (Map.Entry<String, Supplier<? extends Compiler>> entry : this.compilerByExtension.entrySet()) {
            String extension = entry.getKey();
            if (!filename.endsWith(extension)) continue;
            Compiler compiler = entry.getValue().get();
            return compiler.compile(path, content);
        }
        return content;
    }
}

