/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.compilers;

import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

abstract class AbstractNashornCompiler {
    private final CompiledScript compiledScript;
    private final Bindings bindings;

    protected AbstractNashornCompiler(String scriptPath) {
        ScriptEngine nashorn = new ScriptEngineManager().getEngineByName("nashorn");
        try (InputStreamReader reader = new InputStreamReader(ClassLoader.getSystemResourceAsStream(scriptPath), StandardCharsets.UTF_8);){
            this.compiledScript = ((Compilable)((Object)nashorn)).compile(reader);
            this.bindings = nashorn.getBindings(100);
        }
        catch (IOException | ScriptException e) {
            throw new IllegalStateException(e);
        }
    }

    protected abstract void setBindings(Bindings var1, String var2);

    public synchronized String compile(String source) throws IOException {
        this.setBindings(this.bindings, source);
        try {
            return this.compiledScript.eval(this.bindings).toString();
        }
        catch (ScriptException e) {
            throw new IOException("Unable to compile", e);
        }
    }
}

