/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.routes;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import net.codestory.http.internal.Context;
import net.codestory.http.io.InputStreams;
import net.codestory.http.io.Resources;
import net.codestory.http.payload.Payload;
import net.codestory.http.routes.Route;
import net.codestory.http.types.ContentTypes;

class StaticRoute
implements Route {
    protected static final Path NOT_FOUND = Paths.get("", new String[0]);

    StaticRoute() {
    }

    @Override
    public Payload apply(String uri, Context context) throws IOException {
        if (uri.startsWith("/webjars/")) {
            return this.serverFromWebjar(uri, context);
        }
        return this.serveFromApp(uri, context);
    }

    private Payload serverFromWebjar(String uri, Context context) throws IOException {
        URL classpathUrl = ClassLoader.getSystemResource("META-INF/resources" + uri);
        if (classpathUrl == null) {
            return Payload.notFound();
        }
        if (context.getHeader("if-modified-since") != null) {
            return Payload.notModified();
        }
        try (InputStream stream = classpathUrl.openStream();){
            String contentType = ContentTypes.get(Paths.get(uri, new String[0]));
            byte[] data = InputStreams.readBytes(stream);
            Payload payload = new Payload(contentType, data).withHeader("cache-control", "public, max-age=31536000").withHeader("last-modified", DateTimeFormatter.RFC_1123_DATE_TIME.format(ZonedDateTime.now().minusMonths(1L))).withHeader("expires", DateTimeFormatter.RFC_1123_DATE_TIME.format(ZonedDateTime.now().plusWeeks(1L)));
            return payload;
        }
    }

    private Payload serveFromApp(String uri, Context context) {
        Path path = this.path(uri);
        if (path == NOT_FOUND) {
            if (uri.endsWith("/") || this.path(uri + "/") == NOT_FOUND) {
                return Payload.notFound();
            }
            return Payload.seeOther(uri + "/");
        }
        if (!"GET".equalsIgnoreCase(context.method())) {
            return Payload.methodNotAllowed();
        }
        return new Payload(path);
    }

    protected Path path(String uri) {
        Path path = Resources.findExistingPath(uri);
        return path != null && Resources.isPublic(path) ? path : NOT_FOUND;
    }
}

