/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.routes;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.codestory.http.compilers.Compiler;
import net.codestory.http.internal.Context;
import net.codestory.http.io.Resources;
import net.codestory.http.io.Strings;
import net.codestory.http.payload.Payload;
import net.codestory.http.routes.Route;
import net.codestory.http.types.ContentTypes;

class SourceMapRoute
implements Route {
    SourceMapRoute() {
    }

    @Override
    public Payload apply(String uri, Context context) throws IOException {
        if (!uri.endsWith(".css.map")) {
            return Payload.notFound();
        }
        Path pathLess = Paths.get(Strings.substringBeforeLast(uri, ".css.map") + ".less", new String[0]);
        if (!Resources.isPublic(pathLess)) {
            return Payload.notFound();
        }
        if (!"GET".equalsIgnoreCase(context.method())) {
            return Payload.methodNotAllowed();
        }
        Path pathMap = Paths.get(uri, new String[0]);
        String contentType = ContentTypes.get(pathMap);
        String less = Resources.read(pathLess, StandardCharsets.UTF_8);
        String map = Compiler.compile(pathMap, less);
        return new Payload(contentType, map);
    }
}

