/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.routes;

import java.io.IOException;
import net.codestory.http.internal.Context;
import net.codestory.http.payload.Payload;
import net.codestory.http.routes.Route;

abstract class AbstractRoute
implements Route {
    AbstractRoute() {
    }

    @Override
    public Payload apply(String uri, Context context) throws IOException {
        if (!this.matchUri(uri)) {
            if (uri.endsWith("/") || !this.matchUri(uri + "/")) {
                return Payload.notFound();
            }
            return Payload.seeOther(uri + "/");
        }
        if (!this.matchMethod(context)) {
            return Payload.methodNotAllowed();
        }
        String[] parameters = this.parseParameters(uri, context);
        Object body = this.body(context, parameters);
        return new Payload(body);
    }

    protected abstract Object body(Context var1, String[] var2);

    protected abstract boolean matchUri(String var1);

    protected abstract boolean matchMethod(Context var1);

    protected abstract String[] parseParameters(String var1, Context var2);
}

