/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.payload;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.codestory.http.compilers.Compiler;
import net.codestory.http.convert.TypeConvert;
import net.codestory.http.internal.Context;
import net.codestory.http.io.InputStreams;
import net.codestory.http.io.Resources;
import net.codestory.http.templating.Model;
import net.codestory.http.templating.ModelAndView;
import net.codestory.http.templating.Template;
import net.codestory.http.types.ContentTypes;
import org.simpleframework.http.Cookie;
import org.simpleframework.http.Response;
import org.simpleframework.http.Status;

public class Payload {
    private final String contentType;
    private final Object content;
    private int code;
    private final Map<String, String> headers;
    private final List<Cookie> cookies;

    public Payload(Object content) {
        this(null, content);
    }

    public Payload(String contentType, Object content) {
        this(contentType, content, 200);
    }

    public Payload(int code) {
        this(null, null, code);
    }

    public Payload(String contentType, Object content, int code) {
        if (content instanceof Payload) {
            Payload wrapped = (Payload)content;
            this.contentType = null == contentType ? wrapped.contentType : contentType;
            this.content = wrapped.content;
            this.code = wrapped.code;
            this.headers = new LinkedHashMap<String, String>(wrapped.headers);
            this.cookies = new ArrayList<Cookie>(wrapped.cookies);
        } else {
            this.contentType = contentType;
            this.content = content;
            this.code = code;
            this.headers = new LinkedHashMap<String, String>();
            this.cookies = new ArrayList<Cookie>();
        }
    }

    public Payload withHeader(String key, String value) {
        this.headers.put(key, value);
        return this;
    }

    public Payload withHeaders(Map<String, String> headers) {
        this.headers.putAll(headers);
        return this;
    }

    public Payload withCookie(String name, int value) {
        return this.withCookie(name, Integer.toString(value));
    }

    public Payload withCookie(String name, long value) {
        return this.withCookie(name, Long.toString(value));
    }

    public Payload withCookie(String name, boolean value) {
        return this.withCookie(name, Boolean.toString(value));
    }

    public Payload withCookie(String name, String value) {
        return this.withCookie(new Cookie(name, value, "/", true));
    }

    public Payload withCookie(String name, Object value) {
        return this.withCookie(name, TypeConvert.toJson(value));
    }

    public Payload withCookie(Cookie cookie) {
        this.cookies.add(cookie);
        return this;
    }

    public Payload withCookies(List<Cookie> cookies) {
        cookies.addAll(cookies);
        return this;
    }

    public Payload withCode(int code) {
        this.code = code;
        return this;
    }

    public String rawContentType() {
        return this.contentType;
    }

    public Object rawContent() {
        return this.content;
    }

    public Map<String, String> headers() {
        return this.headers;
    }

    public List<Cookie> cookies() {
        return this.cookies;
    }

    public int code() {
        return this.code;
    }

    public boolean isSuccess() {
        return this.code >= 200 && this.code <= 299;
    }

    public boolean isError() {
        return this.code >= 400 && this.code <= 599;
    }

    public static Payload ok() {
        return new Payload(200);
    }

    public static Payload created() {
        return new Payload(201);
    }

    public static Payload movedPermanently(String url) {
        return new Payload(301).withHeader("Location", url);
    }

    public static Payload seeOther(String uri) {
        return new Payload(303).withHeader("Location", uri);
    }

    public static Payload seeOther(URI uri) {
        return Payload.seeOther(uri.toString());
    }

    public static Payload temporaryRedirect(String uri) {
        return new Payload(307).withHeader("Location", uri);
    }

    public static Payload temporaryRedirect(URI uri) {
        return Payload.temporaryRedirect(uri.toString());
    }

    public static Payload notModified() {
        return new Payload(304);
    }

    public static Payload unauthorized(String realm) {
        return new Payload(401).withHeader("WWW-Authenticate", "Basic realm=\"" + realm + "\"");
    }

    public static Payload forbidden() {
        return new Payload(403);
    }

    public static Payload notFound() {
        return new Payload(404);
    }

    public static Payload methodNotAllowed() {
        return new Payload(405);
    }

    public boolean isBetter(Payload other) {
        if (200 == this.code) {
            return other.code() != 200;
        }
        if (405 == this.code) {
            return other.code() != 200 && other.code() != 405;
        }
        if (303 == this.code) {
            return other.code() != 200 && other.code() != 405 && other.code() != 303;
        }
        return false;
    }

    public void writeTo(Context context) throws IOException {
        Response response = context.response();
        this.headers.entrySet().forEach(entry -> response.setValue((String)entry.getKey(), (String)entry.getValue()));
        this.addHeadersForContent(response);
        this.cookies.forEach(cookie -> response.setCookie(cookie));
        response.setStatus(Status.getStatus((int)this.code));
        String uri = context.uri();
        byte[] data = this.getData(uri);
        if (data != null) {
            response.setValue("Content-Type", this.getContentType(uri));
            response.setContentLength((long)data.length);
            response.getOutputStream().write(data);
        } else {
            response.setContentLength(0L);
        }
    }

    public String getContentType(String uri) {
        if (this.contentType != null) {
            return this.contentType;
        }
        if (this.content instanceof File) {
            File file = (File)this.content;
            return ContentTypes.get(file.toPath());
        }
        if (this.content instanceof Path) {
            Path path = (Path)this.content;
            return ContentTypes.get(path);
        }
        if (this.content instanceof byte[]) {
            return "application/octet-stream";
        }
        if (this.content instanceof String) {
            return "text/html;charset=UTF-8";
        }
        if (this.content instanceof InputStream) {
            return "application/octet-stream";
        }
        if (this.content instanceof ModelAndView) {
            Path path = Resources.findExistingPath(((ModelAndView)this.content).view());
            return ContentTypes.get(path);
        }
        if (this.content instanceof Model) {
            Path path = Resources.findExistingPath(uri);
            return ContentTypes.get(path);
        }
        return "application/json;charset=UTF-8";
    }

    public byte[] getData(String uri) throws IOException {
        if (this.content == null) {
            return null;
        }
        if (this.content instanceof File) {
            return Payload.forPath(((File)this.content).toPath());
        }
        if (this.content instanceof Path) {
            return Payload.forPath((Path)this.content);
        }
        if (this.content instanceof byte[]) {
            return (byte[])this.content;
        }
        if (this.content instanceof String) {
            return Payload.forString((String)this.content);
        }
        if (this.content instanceof InputStream) {
            return Payload.forInputStream((InputStream)this.content);
        }
        if (this.content instanceof ModelAndView) {
            return Payload.forModelAndView((ModelAndView)this.content);
        }
        if (this.content instanceof Model) {
            return Payload.forModelAndView(ModelAndView.of(uri, (Model)this.content));
        }
        return TypeConvert.toByteArray(this.content);
    }

    private void addHeadersForContent(Response response) {
        if (this.content instanceof Path) {
            this.addLastModifiedHeader(((Path)this.content).toFile(), response);
        } else if (this.content instanceof File) {
            this.addLastModifiedHeader((File)this.content, response);
        }
    }

    private void addLastModifiedHeader(File file, Response response) {
        response.setValue("Last-Modified", DateTimeFormatter.RFC_1123_DATE_TIME.format(ZonedDateTime.ofInstant(Instant.ofEpochMilli(file.lastModified()), ZoneOffset.systemDefault())));
    }

    private static byte[] forString(String value) {
        return value.getBytes(StandardCharsets.UTF_8);
    }

    private static byte[] forInputStream(InputStream stream) throws IOException {
        return InputStreams.readBytes(stream);
    }

    private static byte[] forModelAndView(ModelAndView modelAndView) {
        return Payload.forString(new Template(modelAndView.view()).render(modelAndView.model()));
    }

    private static byte[] forPath(Path path) throws IOException {
        if (ContentTypes.is_binary(path)) {
            return Resources.readBytes(path);
        }
        if (ContentTypes.support_templating(path)) {
            return Payload.forModelAndView(ModelAndView.of(path.toString()));
        }
        String content = Resources.read(path, StandardCharsets.UTF_8);
        String compiled = Compiler.compile(path, content);
        return Payload.forString(compiled);
    }
}

