/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.filters.etag;

import java.io.IOException;
import net.codestory.http.filters.Filter;
import net.codestory.http.filters.PayloadSupplier;
import net.codestory.http.internal.Context;
import net.codestory.http.misc.Md5;
import net.codestory.http.payload.Payload;

public class EtagFilter
implements Filter {
    @Override
    public Payload apply(String uri, Context context, PayloadSupplier nextFilter) throws IOException {
        Payload payload = nextFilter.get();
        if (payload == null) {
            return null;
        }
        byte[] data = payload.getData(uri);
        if (data == null) {
            return payload;
        }
        if (!payload.isSuccess()) {
            return payload;
        }
        String previousEtag = context.getHeader("If-None-Match");
        String currentEtag = Md5.of(data);
        if (currentEtag.equals(previousEtag)) {
            return Payload.notModified();
        }
        return payload.withHeader("ETag", currentEtag);
    }
}

