/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.filters.basic;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import net.codestory.http.filters.Filter;
import net.codestory.http.filters.PayloadSupplier;
import net.codestory.http.internal.Context;
import net.codestory.http.payload.Payload;

public class BasicAuthFilter
implements Filter {
    private final String uriPrefix;
    private final String realm;
    private final List<String> hashes;

    public BasicAuthFilter(String uriPrefix, String realm, Map<String, String> users) {
        this.uriPrefix = uriPrefix;
        this.realm = realm;
        this.hashes = new ArrayList<String>();
        users.entrySet().forEach(entry -> {
            String string = (String)entry.getKey();
            String string2 = (String)entry.getValue();
            String string3 = Base64.getEncoder().encodeToString((string + ":" + string2).getBytes());
            this.hashes.add("Basic " + string3);
        });
    }

    @Override
    public Payload apply(String uri, Context context, PayloadSupplier nextFilter) throws IOException {
        if (!uri.startsWith(this.uriPrefix)) {
            return nextFilter.get();
        }
        String authorizationHeader = context.getHeader("Authorization");
        if (authorizationHeader == null || !this.hashes.contains(authorizationHeader.trim())) {
            return Payload.unauthorized(this.realm);
        }
        return nextFilter.get();
    }
}

