/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.routes;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.Supplier;
import net.codestory.http.annotations.Produces;
import net.codestory.http.payload.Payload;

class AbstractReflectionRoute {
    protected final Supplier<Object> resource;
    protected final Method method;
    protected final String contentType;

    protected AbstractReflectionRoute(Supplier<Object> resource, Method method) {
        this.resource = resource;
        this.method = method;
        this.contentType = AbstractReflectionRoute.findContentType(method);
    }

    protected Object payload(Object[] arguments) throws InvocationTargetException, IllegalAccessException {
        Object target = this.resource.get();
        Object response = AbstractReflectionRoute.invoke(this.method, target, arguments);
        Object payload = AbstractReflectionRoute.emptyIfNull(response);
        return new Payload(this.contentType, payload);
    }

    private static Object invoke(Method method, Object target, Object[] arguments) throws IllegalAccessException, InvocationTargetException {
        method.setAccessible(true);
        return method.invoke(target, arguments);
    }

    private static Object emptyIfNull(Object payload) {
        return payload == null ? "" : payload;
    }

    private static String findContentType(Method method) {
        Produces annotation = method.getAnnotation(Produces.class);
        return annotation == null ? null : annotation.value();
    }
}

