/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.io;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import net.codestory.http.io.ClassPaths;

class ClasspathScanner {
    ClasspathScanner() {
    }

    public Set<String> getResources(String prefix) {
        LinkedHashSet<String> resources = new LinkedHashSet<String>();
        for (URL url : ClasspathScanner.urls(prefix)) {
            for (String path : ClassPaths.fromURL(url)) {
                if (!path.startsWith(prefix) || path.endsWith(".class")) continue;
                resources.add(path);
            }
        }
        return resources;
    }

    private static Set<URL> urls(String name) {
        LinkedHashSet<URL> result = new LinkedHashSet<URL>();
        try {
            Enumeration<URL> urls = ClasspathScanner.class.getClassLoader().getResources(name);
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                int index = url.toExternalForm().lastIndexOf(name);
                if (index != -1) {
                    result.add(new URL(url.toExternalForm().substring(0, index)));
                    continue;
                }
                result.add(url);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }
}

