/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.internal;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import net.codestory.http.io.InputStreams;
import org.simpleframework.http.Cookie;
import org.simpleframework.http.Query;
import org.simpleframework.http.Request;
import org.simpleframework.http.Response;

public class Context {
    private final Request request;
    private final Response response;
    private final Query query;

    public Context(Request request, Response response) {
        this.request = request;
        this.response = response;
        this.query = request.getQuery();
    }

    public Cookie cookie(String name) {
        return this.request.getCookie(name);
    }

    public List<Cookie> cookies() {
        return this.request.getCookies();
    }

    public String get(String name) {
        return (String)this.query.get((Object)name);
    }

    public List<String> getAll(String name) {
        return this.query.getAll((Object)name);
    }

    public int getInteger(String name) {
        return this.query.getInteger((Object)name);
    }

    public float getFloat(String name) {
        return this.query.getFloat((Object)name);
    }

    public boolean getBoolean(String name) {
        return this.query.getBoolean((Object)name);
    }

    public String getHeader(String name) {
        return this.request.getValue(name);
    }

    public List<String> getHeaders(String name) {
        return this.request.getValues(name);
    }

    public String method() {
        return this.request.getMethod();
    }

    public Map<String, String> keyValues() {
        return this.query;
    }

    public Request request() {
        return this.request;
    }

    public Response response() {
        return this.response;
    }

    public byte[] payload() {
        try {
            return InputStreams.readBytes(this.request.getInputStream());
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to read payload", e);
        }
    }
}

