/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.filters.basic;

import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import net.codestory.http.filters.Filter;
import org.simpleframework.http.Request;
import org.simpleframework.http.Response;
import org.simpleframework.http.Status;

public class BasicAuthFilter
implements Filter {
    private final String uriPrefix;
    private final String realm;
    private final List<String> hashes;

    public BasicAuthFilter(String uriPrefix, String realm, Map<String, String> users) {
        this.uriPrefix = uriPrefix;
        this.realm = realm;
        this.hashes = new ArrayList<String>();
        users.entrySet().forEach(entry -> {
            String string = (String)entry.getKey();
            String string2 = (String)entry.getValue();
            String string3 = Base64.getEncoder().encodeToString((string + ":" + string2).getBytes());
            this.hashes.add("Basic " + string3);
        });
    }

    @Override
    public boolean apply(String uri, Request request, Response response) {
        if (!uri.startsWith(this.uriPrefix)) {
            return false;
        }
        String authorizationHeader = request.getValue("Authorization");
        if (authorizationHeader == null || !this.hashes.contains(authorizationHeader.trim())) {
            response.setStatus(Status.UNAUTHORIZED);
            response.setValue("WWW-Authenticate", "Basic realm=\"" + this.realm + "\"");
            return true;
        }
        return false;
    }
}

