/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.compilers;

import com.github.rjeschke.txtmark.BlockEmitter;
import com.github.rjeschke.txtmark.Configuration;
import com.github.rjeschke.txtmark.Decorator;
import com.github.rjeschke.txtmark.Processor;
import com.github.sommeri.less4j.Less4jException;
import com.github.sommeri.less4j.LessSource;
import com.github.sommeri.less4j.core.ThreadUnsafeLessCompiler;
import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import net.codestory.http.compilers.AsciidocCompiler;
import net.codestory.http.compilers.CoffeeCompiler;
import net.codestory.http.compilers.FormulaPlugin;
import net.codestory.http.compilers.PathSource;
import net.codestory.http.compilers.TablePlugin;
import net.codestory.http.misc.MemoizingSupplier;
import org.markdown4j.CodeBlockEmitter;
import org.markdown4j.ExtDecorator;
import org.markdown4j.IncludePlugin;
import org.markdown4j.Plugin;
import org.markdown4j.WebSequencePlugin;
import org.markdown4j.YumlPlugin;

public enum Compiler {
    COFFEE{
        private final Supplier<CoffeeCompiler> coffeeCompiler = MemoizingSupplier.memoize(() -> new CoffeeCompiler());

        @Override
        String doCompile(Path path, String coffee) throws IOException {
            return this.coffeeCompiler.get().compile(coffee);
        }
    }
    ,
    MARKDOWN{
        private final Supplier<Configuration> configuration = MemoizingSupplier.memoize(() -> Configuration.builder().forceExtentedProfile().registerPlugins(new Plugin[]{new YumlPlugin(), new WebSequencePlugin(), new IncludePlugin(), new FormulaPlugin(), new TablePlugin()}).setDecorator((Decorator)new ExtDecorator()).setCodeBlockEmitter((BlockEmitter)new CodeBlockEmitter()).build());

        @Override
        String doCompile(Path path, String markdown) throws IOException {
            return Processor.process((String)markdown, (Configuration)this.configuration.get());
        }
    }
    ,
    LESS{

        @Override
        String doCompile(Path path, String less) throws IOException {
            try {
                return new ThreadUnsafeLessCompiler().compile((LessSource)new PathSource(path, less)).getCss();
            }
            catch (Less4jException e) {
                throw new IOException("Unable to compile less", e);
            }
        }
    }
    ,
    LESS_MAP{

        @Override
        String doCompile(Path path, String less) throws IOException {
            try {
                return new ThreadUnsafeLessCompiler().compile((LessSource)new PathSource(path, less)).getSourceMap();
            }
            catch (Less4jException e) {
                throw new IOException("Unable to compile less", e);
            }
        }
    }
    ,
    ASCIIDOC{
        private final Supplier<AsciidocCompiler> asciidocCompiler = MemoizingSupplier.memoize(() -> new AsciidocCompiler());

        @Override
        String doCompile(Path path, String asciidoc) throws IOException {
            return this.asciidocCompiler.get().compile(asciidoc);
        }
    }
    ,
    NONE{

        @Override
        String doCompile(Path path, String content) {
            return content;
        }
    };

    private static final ConcurrentMap<String, String> CACHE;

    abstract String doCompile(Path var1, String var2) throws IOException;

    public static String compile(Path path, String content) {
        return CACHE.computeIfAbsent(path.toString() + ";" + content, string2 -> {
            try {
                return Compiler.compilerForPath(path).doCompile(path, content);
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        });
    }

    private static Compiler compilerForPath(Path path) {
        String name = path.toString();
        if (name.endsWith(".less")) {
            return LESS;
        }
        if (name.endsWith(".css.map")) {
            return LESS_MAP;
        }
        if (name.endsWith(".coffee")) {
            return COFFEE;
        }
        if (name.endsWith(".md") || name.endsWith(".markdown")) {
            return MARKDOWN;
        }
        if (name.endsWith(".asciidoc")) {
            return ASCIIDOC;
        }
        return NONE;
    }

    static {
        CACHE = new ConcurrentHashMap<String, String>();
    }
}

