/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.routes;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import net.codestory.http.Configuration;
import net.codestory.http.annotations.Get;
import net.codestory.http.annotations.Post;
import net.codestory.http.annotations.Put;
import net.codestory.http.filters.Filter;
import net.codestory.http.injection.IocAdapter;
import net.codestory.http.injection.Singletons;
import net.codestory.http.internal.UriParser;
import net.codestory.http.payload.Payload;
import net.codestory.http.routes.AnyRoute;
import net.codestory.http.routes.AnyRouteWithContext;
import net.codestory.http.routes.CachedStaticRoute;
import net.codestory.http.routes.CatchAllRoute;
import net.codestory.http.routes.CatchAllRouteWithContext;
import net.codestory.http.routes.FourParamsRoute;
import net.codestory.http.routes.FourParamsRouteWithContext;
import net.codestory.http.routes.Match;
import net.codestory.http.routes.NoParamRoute;
import net.codestory.http.routes.NoParamRouteWithContext;
import net.codestory.http.routes.OneParamRoute;
import net.codestory.http.routes.OneParamRouteWithContext;
import net.codestory.http.routes.ReflectionRoute;
import net.codestory.http.routes.ReflectionRouteWithContext;
import net.codestory.http.routes.Route;
import net.codestory.http.routes.RouteWithContextWrapper;
import net.codestory.http.routes.RouteWrapper;
import net.codestory.http.routes.Routes;
import net.codestory.http.routes.SourceMapRoute;
import net.codestory.http.routes.StaticRoute;
import net.codestory.http.routes.ThreeParamsRoute;
import net.codestory.http.routes.ThreeParamsRouteWithContext;
import net.codestory.http.routes.TwoParamsRoute;
import net.codestory.http.routes.TwoParamsRouteWithContext;
import org.simpleframework.http.Request;
import org.simpleframework.http.Response;

public class RouteCollection
implements Routes {
    private final List<Route> routes;
    private final List<Supplier<Filter>> filters;
    private IocAdapter iocAdapter = new Singletons();

    public RouteCollection() {
        this.routes = new LinkedList<Route>();
        this.filters = new LinkedList<Supplier<Filter>>();
    }

    @Override
    public void setIocAdapter(IocAdapter iocAdapter) {
        this.iocAdapter = iocAdapter;
    }

    @Override
    public void include(Class<? extends Configuration> configurationClass) {
        this.iocAdapter.get(configurationClass).configure(this);
    }

    @Override
    public void include(Configuration configuration) {
        configuration.configure(this);
    }

    @Override
    public void filter(Class<? extends Filter> filterClass) {
        this.filters.add(() -> (Filter)this.iocAdapter.get(filterClass));
    }

    @Override
    public void filter(Filter filter) {
        this.filters.add(() -> filter);
    }

    @Override
    public void add(Class<?> resourceType) {
        this.addResource("", resourceType, () -> this.iocAdapter.get(resourceType));
    }

    @Override
    public void add(String urlPrefix, Class<?> resourceType) {
        this.addResource(urlPrefix, resourceType, () -> this.iocAdapter.get(resourceType));
    }

    @Override
    public void add(Object resource) {
        this.addResource("", resource.getClass(), () -> resource);
    }

    @Override
    public void add(String urlPrefix, Object resource) {
        this.addResource(urlPrefix, resource.getClass(), () -> resource);
    }

    private void addResource(String urlPrefix, Class<?> type, Supplier<Object> resource) {
        if (type.getName().contains("EnhancerByMockito")) {
            type = type.getSuperclass();
        }
        for (Method method : type.getMethods()) {
            for (Get get : (Get[])method.getDeclaredAnnotationsByType(Get.class)) {
                this.addResource("GET", method, resource, urlPrefix + get.value());
            }
            for (Annotation annotation : (Post[])method.getDeclaredAnnotationsByType(Post.class)) {
                this.addResource("POST", method, resource, urlPrefix + annotation.value());
            }
            for (Annotation annotation : (Put[])method.getDeclaredAnnotationsByType(Put.class)) {
                this.addResource("PUT", method, resource, urlPrefix + annotation.value());
            }
        }
    }

    private void addResource(String httpMethod, Method method, Supplier<Object> resource, String uriPattern) {
        int uriParamsCount;
        int methodParamsCount = method.getParameterCount();
        if (methodParamsCount == (uriParamsCount = UriParser.paramsCount(uriPattern))) {
            this.add(httpMethod, RouteCollection.checkParametersCount(uriPattern, methodParamsCount), new ReflectionRoute(resource, method));
        } else if (methodParamsCount == uriParamsCount + 1) {
            this.add(httpMethod, RouteCollection.checkParametersCount(uriPattern, methodParamsCount - 1), new ReflectionRouteWithContext(resource, method));
        } else {
            throw new IllegalArgumentException("Expected " + uriParamsCount + " or " + (uriParamsCount + 1) + " parameters in " + uriPattern);
        }
    }

    @Override
    public void get(String uriPattern, Object payload) {
        this.get(uriPattern, () -> payload);
    }

    @Override
    public void get(String uriPattern, NoParamRoute route) {
        this.add("GET", RouteCollection.checkParametersCount(uriPattern, 0), route);
    }

    @Override
    public void get(String uriPattern, OneParamRoute route) {
        this.add("GET", RouteCollection.checkParametersCount(uriPattern, 1), route);
    }

    @Override
    public void get(String uriPattern, TwoParamsRoute route) {
        this.add("GET", RouteCollection.checkParametersCount(uriPattern, 2), route);
    }

    @Override
    public void get(String uriPattern, ThreeParamsRoute route) {
        this.add("GET", RouteCollection.checkParametersCount(uriPattern, 3), route);
    }

    @Override
    public void get(String uriPattern, FourParamsRoute route) {
        this.add("GET", RouteCollection.checkParametersCount(uriPattern, 4), route);
    }

    @Override
    public void get(String uriPattern, NoParamRouteWithContext route) {
        this.add("GET", RouteCollection.checkParametersCount(uriPattern, 0), route);
    }

    @Override
    public void get(String uriPattern, OneParamRouteWithContext route) {
        this.add("GET", RouteCollection.checkParametersCount(uriPattern, 1), route);
    }

    @Override
    public void get(String uriPattern, TwoParamsRouteWithContext route) {
        this.add("GET", RouteCollection.checkParametersCount(uriPattern, 2), route);
    }

    @Override
    public void get(String uriPattern, ThreeParamsRouteWithContext route) {
        this.add("GET", RouteCollection.checkParametersCount(uriPattern, 3), route);
    }

    @Override
    public void get(String uriPattern, FourParamsRouteWithContext route) {
        this.add("GET", RouteCollection.checkParametersCount(uriPattern, 4), route);
    }

    @Override
    public void post(String uriPattern, NoParamRoute route) {
        this.add("POST", RouteCollection.checkParametersCount(uriPattern, 0), route);
    }

    @Override
    public void post(String uriPattern, OneParamRoute route) {
        this.add("POST", RouteCollection.checkParametersCount(uriPattern, 1), route);
    }

    @Override
    public void post(String uriPattern, TwoParamsRoute route) {
        this.add("POST", RouteCollection.checkParametersCount(uriPattern, 2), route);
    }

    @Override
    public void post(String uriPattern, ThreeParamsRoute route) {
        this.add("POST", RouteCollection.checkParametersCount(uriPattern, 3), route);
    }

    @Override
    public void post(String uriPattern, FourParamsRoute route) {
        this.add("POST", RouteCollection.checkParametersCount(uriPattern, 4), route);
    }

    @Override
    public void post(String uriPattern, NoParamRouteWithContext route) {
        this.add("POST", RouteCollection.checkParametersCount(uriPattern, 0), route);
    }

    @Override
    public void post(String uriPattern, OneParamRouteWithContext route) {
        this.add("POST", RouteCollection.checkParametersCount(uriPattern, 1), route);
    }

    @Override
    public void post(String uriPattern, TwoParamsRouteWithContext route) {
        this.add("POST", RouteCollection.checkParametersCount(uriPattern, 2), route);
    }

    @Override
    public void post(String uriPattern, ThreeParamsRouteWithContext route) {
        this.add("POST", RouteCollection.checkParametersCount(uriPattern, 3), route);
    }

    @Override
    public void post(String uriPattern, FourParamsRouteWithContext route) {
        this.add("POST", RouteCollection.checkParametersCount(uriPattern, 4), route);
    }

    @Override
    public void put(String uriPattern, NoParamRoute route) {
        this.add("PUT", RouteCollection.checkParametersCount(uriPattern, 0), route);
    }

    @Override
    public void put(String uriPattern, OneParamRoute route) {
        this.add("PUT", RouteCollection.checkParametersCount(uriPattern, 1), route);
    }

    @Override
    public void put(String uriPattern, TwoParamsRoute route) {
        this.add("PUT", RouteCollection.checkParametersCount(uriPattern, 2), route);
    }

    @Override
    public void put(String uriPattern, ThreeParamsRoute route) {
        this.add("PUT", RouteCollection.checkParametersCount(uriPattern, 3), route);
    }

    @Override
    public void put(String uriPattern, FourParamsRoute route) {
        this.add("PUT", RouteCollection.checkParametersCount(uriPattern, 4), route);
    }

    @Override
    public void put(String uriPattern, NoParamRouteWithContext route) {
        this.add("PUT", RouteCollection.checkParametersCount(uriPattern, 0), route);
    }

    @Override
    public void put(String uriPattern, OneParamRouteWithContext route) {
        this.add("PUT", RouteCollection.checkParametersCount(uriPattern, 1), route);
    }

    @Override
    public void put(String uriPattern, TwoParamsRouteWithContext route) {
        this.add("PUT", RouteCollection.checkParametersCount(uriPattern, 2), route);
    }

    @Override
    public void put(String uriPattern, ThreeParamsRouteWithContext route) {
        this.add("PUT", RouteCollection.checkParametersCount(uriPattern, 3), route);
    }

    @Override
    public void put(String uriPattern, FourParamsRouteWithContext route) {
        this.add("PUT", RouteCollection.checkParametersCount(uriPattern, 4), route);
    }

    @Override
    public void catchAll(Object payload) {
        this.catchAll(() -> payload);
    }

    @Override
    public void catchAll(NoParamRoute route) {
        this.routes.add(new CatchAllRoute(route));
    }

    @Override
    public void catchAll(NoParamRouteWithContext route) {
        this.routes.add(new CatchAllRouteWithContext(route));
    }

    private void add(String method, String uriPattern, AnyRoute route) {
        this.routes.add(new RouteWrapper(method, uriPattern, route));
    }

    private void add(String method, String uriPattern, AnyRouteWithContext route) {
        this.routes.add(new RouteWithContextWrapper(method, uriPattern, route));
    }

    public void addStaticRoutes(boolean cache) {
        this.routes.add(cache ? new CachedStaticRoute() : new StaticRoute());
        this.routes.add(new SourceMapRoute());
    }

    public Match apply(Request request, Response response) throws IOException {
        String uri = request.getPath().getPath();
        if (uri == null) {
            return Match.WRONG_URL;
        }
        for (Supplier<Filter> filter : this.filters) {
            if (!filter.get().apply(uri, request, response)) continue;
            return Match.OK;
        }
        Match bestMatch = Match.WRONG_URL;
        for (Route route : this.routes) {
            Match match = route.apply(uri, request, response);
            if (match == Match.OK) {
                return Match.OK;
            }
            if (!match.isBetter(bestMatch)) continue;
            bestMatch = match;
        }
        if (bestMatch == Match.TRY_WITH_LEADING_SLASH) {
            Payload.seeOther(uri + "/").writeTo(response);
            return Match.OK;
        }
        return bestMatch;
    }

    private static String checkParametersCount(String uriPattern, int count) {
        if (UriParser.paramsCount(uriPattern) != count) {
            String error = count == 1 ? "1 parameter" : count + " parameters";
            throw new IllegalArgumentException("Expected " + error + " in " + uriPattern);
        }
        return uriPattern;
    }
}

