/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.routes;

import java.io.IOException;
import net.codestory.http.payload.Payload;
import net.codestory.http.routes.Match;
import net.codestory.http.routes.Route;
import net.codestory.http.templating.Model;
import net.codestory.http.templating.ModelAndView;
import org.simpleframework.http.Request;
import org.simpleframework.http.Response;

abstract class AbstractRoute
implements Route {
    AbstractRoute() {
    }

    @Override
    public Match apply(String uri, Request request, Response response) throws IOException {
        if (!this.matchUri(uri)) {
            if (!uri.endsWith("/") && this.matchUri(uri + "/")) {
                return Match.TRY_WITH_LEADING_SLASH;
            }
            return Match.WRONG_URL;
        }
        if (!this.matchMethod(request)) {
            return Match.WRONG_METHOD;
        }
        String[] parameters = this.parseParameters(uri, request);
        Object body = this.body(request, response, parameters);
        if (body instanceof Model) {
            body = ModelAndView.of(uri, (Model)body);
        }
        Payload payload = new Payload(body);
        payload.writeTo(response);
        return Match.OK;
    }

    protected abstract Object body(Request var1, Response var2, String[] var3);

    protected abstract boolean matchUri(String var1);

    protected abstract boolean matchMethod(Request var1);

    protected abstract String[] parseParameters(String var1, Request var2);
}

