/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.payload;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.codestory.http.compilers.Compiler;
import net.codestory.http.convert.TypeConvert;
import net.codestory.http.io.InputStreams;
import net.codestory.http.io.Resources;
import net.codestory.http.templating.ModelAndView;
import net.codestory.http.templating.Template;
import net.codestory.http.types.ContentTypes;
import org.simpleframework.http.Cookie;
import org.simpleframework.http.Response;

public class Payload {
    private final String contentType;
    private final Object content;
    private final int code;
    private final Map<String, String> headers;
    private final List<Cookie> cookies;

    public Payload(Object content) {
        this(null, content);
    }

    public Payload(String contentType, Object content) {
        this(contentType, content, 200);
    }

    public Payload(int code) {
        this(null, null, code);
    }

    public Payload(String contentType, Object content, int code) {
        if (content instanceof Payload) {
            Payload wrapped = (Payload)content;
            this.contentType = null == contentType ? wrapped.contentType : contentType;
            this.content = wrapped.content;
            this.code = wrapped.code;
            this.headers = new LinkedHashMap<String, String>(wrapped.headers);
            this.cookies = new ArrayList<Cookie>(wrapped.cookies);
        } else {
            this.contentType = contentType;
            this.content = content;
            this.code = code;
            this.headers = new LinkedHashMap<String, String>();
            this.cookies = new ArrayList<Cookie>();
        }
    }

    public Payload withHeader(String key, String value) {
        this.headers.put(key, value);
        return this;
    }

    public Payload withCookie(String name, String value) {
        return this.withCookie(new Cookie(name, value, "/", true));
    }

    public Payload withCookie(Cookie cookie) {
        this.cookies.add(cookie);
        return this;
    }

    public String rawContentType() {
        return this.contentType;
    }

    public Object rawContent() {
        return this.content;
    }

    public int code() {
        return this.code;
    }

    public static Payload seeOther(String url) {
        return new Payload(303).withHeader("Location", url);
    }

    public static Payload movedPermanently(String url) {
        return new Payload(301).withHeader("Location", url);
    }

    public static Payload forbidden() {
        return new Payload(403);
    }

    public void writeTo(Response response) throws IOException {
        this.headers.entrySet().forEach(entry -> response.setValue((String)entry.getKey(), (String)entry.getValue()));
        this.cookies.forEach(cookie -> response.setCookie(cookie));
        response.setCode(this.code);
        byte[] data = this.getData();
        if (data != null) {
            response.setValue("Content-Type", this.getContentType());
            response.setContentLength((long)data.length);
            response.getOutputStream().write(data);
        } else {
            response.setContentLength(0L);
        }
    }

    String getContentType() {
        if (this.contentType != null) {
            return this.contentType;
        }
        if (this.content instanceof File) {
            File file = (File)this.content;
            return ContentTypes.get(file.toPath());
        }
        if (this.content instanceof Path) {
            Path path = (Path)this.content;
            return ContentTypes.get(path);
        }
        if (this.content instanceof byte[]) {
            return "application/octet-stream";
        }
        if (this.content instanceof String) {
            return "text/html";
        }
        if (this.content instanceof InputStream) {
            return "application/octet-stream";
        }
        if (this.content instanceof ModelAndView) {
            Path path = Resources.findExistingPath(((ModelAndView)this.content).view());
            return ContentTypes.get(path);
        }
        return "application/json";
    }

    byte[] getData() throws IOException {
        if (this.content == null) {
            return null;
        }
        if (this.content instanceof File) {
            return Payload.forPath(((File)this.content).toPath());
        }
        if (this.content instanceof Path) {
            return Payload.forPath((Path)this.content);
        }
        if (this.content instanceof byte[]) {
            return (byte[])this.content;
        }
        if (this.content instanceof String) {
            return Payload.forString((String)this.content);
        }
        if (this.content instanceof InputStream) {
            return Payload.forInputStream((InputStream)this.content);
        }
        if (this.content instanceof ModelAndView) {
            return Payload.forModelAndView((ModelAndView)this.content);
        }
        return TypeConvert.toByteArray(this.content);
    }

    private static byte[] forString(String value) {
        return value.getBytes(StandardCharsets.UTF_8);
    }

    private static byte[] forInputStream(InputStream stream) throws IOException {
        return InputStreams.readBytes(stream);
    }

    private static byte[] forModelAndView(ModelAndView modelAndView) {
        return Payload.forString(new Template(modelAndView.view()).render(modelAndView.model()));
    }

    private static byte[] forPath(Path path) throws IOException {
        if (ContentTypes.is_binary(path)) {
            return Resources.readBytes(path);
        }
        if (ContentTypes.support_templating(path)) {
            return Payload.forModelAndView(ModelAndView.of(path.toString()));
        }
        String content = Resources.read(path, StandardCharsets.UTF_8);
        String compiled = Compiler.compile(path, content);
        return Payload.forString(compiled);
    }
}

