/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.templating;

import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.codestory.http.compilers.Compiler;
import net.codestory.http.io.Resources;
import net.codestory.http.templating.HandlebarsCompiler;
import net.codestory.http.templating.Model;
import net.codestory.http.templating.YamlFrontMatter;

public class Template {
    private final Path path;

    public Template(String folder, String name) {
        this(folder + (name.startsWith("/") ? name : "/" + name));
    }

    public Template(String uri) {
        Path existing = Resources.findExistingPath(uri);
        if (existing == null) {
            throw new IllegalArgumentException("Template not found " + uri);
        }
        this.path = existing;
    }

    public String render(Model model) {
        return this.render(model.getKeyValues());
    }

    String render(Map<String, Object> keyValues) {
        try {
            YamlFrontMatter yamlFrontMatter = YamlFrontMatter.parse(this.path);
            Map<String, Object> allKeyValues = Template.merge(yamlFrontMatter.getVariables(), keyValues);
            String content = Compiler.compile(this.path, yamlFrontMatter.getContent());
            String body = new HandlebarsCompiler().compile(content, allKeyValues);
            String layout = (String)yamlFrontMatter.getVariables().get("layout");
            if (layout == null) {
                return body;
            }
            return new Template("_layouts", layout).render(allKeyValues).replace("[[body]]", body);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to render template", e);
        }
    }

    private static Map<String, Object> merge(Map<String, Object> first, Map<String, Object> second) {
        HashMap<String, Object> merged = new HashMap<String, Object>();
        merged.putAll(first);
        merged.putAll(second);
        merged.put("body", "[[body]]");
        return merged;
    }
}

