/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.reload;

import com.sun.nio.file.SensitivityWatchEventModifier;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.concurrent.atomic.AtomicBoolean;
import net.codestory.http.Configuration;
import net.codestory.http.reload.RoutesProvider;
import net.codestory.http.routes.RouteCollection;

class ReloadingRoutesProvider
implements RoutesProvider {
    private final Configuration configuration;
    private final AtomicBoolean dirty;
    private RouteCollection routes;

    ReloadingRoutesProvider(Configuration configuration) {
        this.configuration = configuration;
        this.dirty = new AtomicBoolean(true);
        this.startClassChangeWatcher(Paths.get("target/classes/", new String[0]));
    }

    @Override
    public synchronized RouteCollection get() {
        if (this.dirty.get()) {
            System.out.println("Reloading configuration...");
            this.routes = new RouteCollection();
            this.configuration.configure(this.routes);
            this.routes.addStaticRoutes(false);
            this.dirty.set(false);
        }
        return this.routes;
    }

    private void startClassChangeWatcher(Path path) {
        new Thread(() -> this.watchChanges(path)).start();
    }

    private void watchChanges(Path path) {
        WatchService watcher = this.createWatcher(path);
        this.reloadOnChange(watcher);
    }

    private WatchService createWatcher(Path path) {
        try {
            final WatchService watcher = path.getFileSystem().newWatchService();
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attr) throws IOException {
                    dir.register(watcher, new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE}, SensitivityWatchEventModifier.HIGH);
                    return FileVisitResult.CONTINUE;
                }
            });
            return watcher;
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to watch folder " + path);
        }
    }

    private void reloadOnChange(WatchService watcher) {
        while (true) {
            try {
                while (true) {
                    WatchKey take = watcher.take();
                    take.pollEvents().forEach(watchEvent -> this.dirty.set(true));
                    take.reset();
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }
}

