/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Set;
import java.util.TreeSet;
import net.codestory.http.io.InputStreams;
import net.codestory.http.io.Strings;
import net.codestory.http.types.ContentTypes;
import org.reflections.Reflections;
import org.reflections.scanners.ResourcesScanner;
import org.reflections.scanners.Scanner;

public class Resources {
    private static final String ROOT = "app";

    private Resources() {
    }

    public static Set<String> list() {
        final TreeSet<String> paths = new TreeSet<String>();
        try {
            if (!Boolean.getBoolean("http.disable.classpath")) {
                new Reflections(ROOT, new Scanner[]{new ResourcesScanner()}).getResources(string -> true).forEach(string -> paths.add(Resources.relativeName(string)));
            }
            if (!Boolean.getBoolean("http.disable.filesystem")) {
                Files.walkFileTree(Paths.get(ROOT, new String[0]), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                        paths.add(Resources.relativeName(file.toString()));
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        paths.remove("");
        return paths;
    }

    private static String relativeName(String path) {
        return Strings.substringAfter(path, "app/");
    }

    public static boolean isPublic(Path path) {
        for (Path part : path) {
            if (!part.toString().equals("..") && !part.toString().startsWith("_")) continue;
            return false;
        }
        return Resources.exists(path);
    }

    public static Path findExistingPath(String uri) {
        if (uri.endsWith("/")) {
            return Resources.findExistingPath(uri + "index");
        }
        for (String extension : ContentTypes.TEMPLATE_EXTENSIONS) {
            Path templatePath = Paths.get(uri + extension, new String[0]);
            if (!Resources.exists(templatePath)) continue;
            return templatePath;
        }
        return null;
    }

    public static boolean exists(Path path) {
        String pathWithPrefix = Resources.withPrefix(path);
        return Resources.existsInFileSystem(pathWithPrefix) || Resources.existsInClassPath(pathWithPrefix);
    }

    public static String read(Path path, Charset charset) throws IOException {
        String pathWithPrefix = Resources.withPrefix(path);
        return Resources.existsInFileSystem(pathWithPrefix) ? Resources.readFile(pathWithPrefix, charset) : Resources.readClasspath(pathWithPrefix, charset);
    }

    public static byte[] readBytes(Path path) throws IOException {
        String pathWithPrefix = Resources.withPrefix(path);
        return Resources.existsInFileSystem(pathWithPrefix) ? Resources.readFileBytes(pathWithPrefix) : Resources.readClasspathBytes(pathWithPrefix);
    }

    private static String withPrefix(Path path) {
        return ROOT + (path.toString().startsWith("/") ? "" : "/") + path;
    }

    private static boolean existsInClassPath(String path) {
        URL url = ClassLoader.getSystemResource(path);
        if (url == null) {
            return false;
        }
        File file = Resources.fileForClasspath(url);
        return file == null || file.isFile();
    }

    private static boolean existsInFileSystem(String path) {
        return new File(path).isFile();
    }

    private static String readClasspath(String path, Charset charset) throws IOException {
        URL url = ClassLoader.getSystemResource(path);
        if (url == null) {
            throw new IllegalArgumentException("Classpath resource not found classpath:" + path);
        }
        File file = Resources.fileForClasspath(url);
        if (file != null) {
            if (!file.isFile()) {
                throw new IllegalArgumentException("Invalid file classpath: " + path);
            }
            return Resources.readFile(file.getAbsolutePath(), charset);
        }
        try (InputStream from = url.openStream();){
            String string = InputStreams.readString(from, charset);
            return string;
        }
    }

    private static byte[] readClasspathBytes(String path) throws IOException {
        URL url = ClassLoader.getSystemResource(path);
        if (url == null) {
            throw new IllegalArgumentException("Invalid file classpath: " + path);
        }
        File file = Resources.fileForClasspath(url);
        if (file != null) {
            if (!file.isFile()) {
                throw new IllegalArgumentException("Invalid file classpath: " + path);
            }
            return Resources.readFileBytes(file.getAbsolutePath());
        }
        try (InputStream from = url.openStream();){
            byte[] byArray = InputStreams.readBytes(from);
            return byArray;
        }
    }

    private static String readFile(String path, Charset charset) throws IOException {
        return new String(Resources.readFileBytes(path), charset);
    }

    private static byte[] readFileBytes(String path) throws IOException {
        if (!new File(path).isFile()) {
            throw new IllegalArgumentException("Invalid file path: " + path);
        }
        return Files.readAllBytes(Paths.get(path, new String[0]));
    }

    private static File fileForClasspath(URL url) {
        String filename = url.getFile();
        if (filename == null || filename.contains(".jar!")) {
            return null;
        }
        try {
            return new File(URLDecoder.decode(filename, "US-ASCII").replace("/target/classes/", "/src/main/resources/"));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Invalid filename classpath: " + url, e);
        }
    }
}

