/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.convert;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import net.codestory.http.internal.Context;

public class TypeConvert {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);

    private TypeConvert() {
    }

    public static Object[] convert(String[] pathParameters, Context context, Class<?>[] types) {
        Object[] converted = new Object[pathParameters.length + 1];
        for (int i = 0; i < pathParameters.length; ++i) {
            converted[i] = TypeConvert.convert(pathParameters[i], types[i]);
        }
        converted[converted.length - 1] = TypeConvert.convert(context, types[converted.length - 1]);
        return converted;
    }

    public static Object[] convert(String[] pathParameters, Class<?>[] types) {
        Object[] converted = new Object[pathParameters.length];
        for (int i = 0; i < pathParameters.length; ++i) {
            converted[i] = TypeConvert.convert(pathParameters[i], types[i]);
        }
        return converted;
    }

    public static Object convert(Context context, Class<?> type) {
        if (type.isAssignableFrom(Context.class)) {
            return context;
        }
        if (type.isAssignableFrom(Map.class)) {
            return context.keyValues();
        }
        return TypeConvert.convert(context.keyValues(), type);
    }

    public static <T> T convert(String value, Class<T> type) {
        return (T)OBJECT_MAPPER.convertValue((Object)value, type);
    }

    public static <T> T convert(Map<String, String> keyValues, Class<T> type) {
        return (T)OBJECT_MAPPER.convertValue(keyValues, type);
    }

    public static byte[] toByteArray(Object value) throws JsonProcessingException {
        return OBJECT_MAPPER.writer().writeValueAsBytes(value);
    }
}

