/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.templating;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.codestory.http.compilers.Compiler;
import net.codestory.http.io.Resources;
import net.codestory.http.templating.HandlebarsCompiler;
import net.codestory.http.templating.Site;
import net.codestory.http.templating.YamlFrontMatter;
import net.codestory.http.types.ContentTypes;

public class Template {
    private final Path path;

    public Template(String url) {
        this(Paths.get(url, new String[0]));
    }

    public Template(Path path) {
        this.path = path;
    }

    public String render() {
        return this.render(Collections.emptyMap());
    }

    public String render(String key, Object value) {
        return this.render((Map<String, Object> map) -> map.put(key, value));
    }

    public String render(String k1, Object v1, String k2, Object v2) {
        return this.render((Map<String, Object> map) -> {
            map.put(k1, v1);
            map.put(k2, v2);
        });
    }

    public String render(String k1, Object v1, String k2, Object v2, String k3, Object v3) {
        return this.render((Map<String, Object> map) -> {
            map.put(k1, v1);
            map.put(k2, v2);
            map.put(k3, v3);
        });
    }

    public String render(String k1, Object v1, String k2, Object v2, String k3, Object v3, String k4, Object v4) {
        return this.render((Map<String, Object> map) -> {
            map.put(k1, v1);
            map.put(k2, v2);
            map.put(k3, v3);
            map.put(k4, v4);
        });
    }

    private String render(Consumer<Map<String, Object>> addKeyValues) {
        HashMap<String, Object> keyValues = new HashMap<String, Object>();
        addKeyValues.accept(keyValues);
        return this.render(keyValues);
    }

    public String render(Map<String, Object> keyValues) {
        return this.render(Site.get(), keyValues);
    }

    String render(Site site, Map<String, Object> keyValues) {
        try {
            YamlFrontMatter parsedTemplate = YamlFrontMatter.parse(this.path);
            Map<String, Object> allKeyValues = Template.merge(parsedTemplate.getVariables(), keyValues);
            String content = Compiler.compile(this.path, parsedTemplate.getContent());
            String body = new HandlebarsCompiler().compile(content, site, allKeyValues);
            String layout = (String)parsedTemplate.getVariables().get("layout");
            if (layout != null) {
                for (String extension : ContentTypes.TEMPLATE_EXTENSIONS) {
                    Path layoutPath = Paths.get("_layouts", layout + extension);
                    if (!Resources.exists(layoutPath)) continue;
                    return new Template(layoutPath).render(site, allKeyValues).replace("[[body]]", body);
                }
                throw new IllegalStateException("Unable to find layout: " + layout);
            }
            return body;
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to render template", e);
        }
    }

    @SafeVarargs
    private static Map<String, Object> merge(Map<String, Object> ... keyValues) {
        HashMap<String, Object> merged = new HashMap<String, Object>();
        for (Map<String, Object> keyValue : keyValues) {
            merged.putAll(keyValue);
        }
        merged.put("body", "[[body]]");
        return merged;
    }
}

