/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Random;
import net.codestory.http.Configuration;
import net.codestory.http.Payload;
import net.codestory.http.errors.ErrorPage;
import net.codestory.http.routes.Match;
import net.codestory.http.routes.RouteCollection;
import org.simpleframework.http.Request;
import org.simpleframework.http.Response;
import org.simpleframework.http.core.ContainerServer;
import org.simpleframework.transport.Server;
import org.simpleframework.transport.connect.SocketConnection;

public class WebServer {
    private final Server server;
    private final SocketConnection connection;
    private final RouteCollection routes = new RouteCollection();
    private Configuration lastConfiguration;
    private int port;

    public WebServer() {
        try {
            this.server = new ContainerServer(this::handle);
            this.connection = new SocketConnection(this.server);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to create http server", e);
        }
    }

    public static void main(String[] args) throws Exception {
        new WebServer().start(8080);
    }

    public WebServer configure(Configuration configuration) {
        this.routes.reset();
        configuration.configure(this.routes);
        if (this.devMode()) {
            this.lastConfiguration = configuration;
        }
        return this;
    }

    public WebServer startOnRandomPort() {
        Random random = new Random();
        for (int i = 0; i < 20; ++i) {
            try {
                int port = 8183 + random.nextInt(1000);
                this.start(port);
                return this;
            }
            catch (Exception e) {
                System.err.println("Unable to bind server: " + e);
                continue;
            }
        }
        throw new IllegalStateException("Unable to start server");
    }

    public WebServer start(int port) {
        try {
            InetSocketAddress address = new InetSocketAddress(port);
            this.connection.connect((SocketAddress)address);
            this.port = port;
            System.out.println("Server started on port " + port);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to bind the web server on port " + port, e);
        }
        return this;
    }

    public int port() {
        return this.port;
    }

    public void reset() {
        this.lastConfiguration = null;
        this.routes.reset();
    }

    public void stop() {
        try {
            this.server.stop();
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to stop the web server", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handle(Request request, Response response) {
        try {
            this.hotReloadConfigurationInDevMode();
            this.applyRoutes(request, response);
        }
        catch (Exception e) {
            System.out.println("Error " + e);
            e.printStackTrace();
            try {
                this.onError(e, response);
            }
            catch (Exception ioe) {
                System.out.println("Unable to server an error page " + ioe);
                ioe.printStackTrace();
            }
        }
        finally {
            try {
                response.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected void applyRoutes(Request request, Response response) throws IOException {
        Match match = this.routes.apply(request, response);
        if (match != Match.OK) {
            this.onPageNotFound(match, response);
        }
    }

    protected void onPageNotFound(Match match, Response response) throws IOException {
        if (match == Match.WRONG_METHOD) {
            this.errorPage(405, null).writeTo(response);
        } else {
            this.errorPage(404, null).writeTo(response);
        }
    }

    protected void onError(Exception e, Response response) throws IOException {
        if (this.devMode()) {
            this.errorPage(500, e).writeTo(response);
        } else {
            this.errorPage(500, null).writeTo(response);
        }
    }

    protected Payload errorPage(int code, Exception e) throws IOException {
        return new ErrorPage(code, e).payload();
    }

    protected boolean devMode() {
        return !Boolean.getBoolean("PROD_MODE");
    }

    protected void hotReloadConfigurationInDevMode() {
        if (this.lastConfiguration != null) {
            System.out.println("Reloading configuration");
            this.configure(this.lastConfiguration);
        }
    }
}

