/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.internal;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import net.codestory.http.io.InputStreams;
import org.simpleframework.http.Cookie;
import org.simpleframework.http.Query;
import org.simpleframework.http.Request;

public class Context {
    private final Request request;
    private final Query query;

    public Context(Request request) {
        this.request = request;
        this.query = request.getQuery();
    }

    public Cookie getCookie(String name) {
        return this.request.getCookie(name);
    }

    public List<Cookie> getCookies() {
        return this.request.getCookies();
    }

    public String get(String name) {
        return (String)this.query.get((Object)name);
    }

    public List<String> getAll(String name) {
        return this.query.getAll((Object)name);
    }

    public int getInteger(String name) {
        return this.query.getInteger((Object)name);
    }

    public float getFloat(String name) {
        return this.query.getFloat((Object)name);
    }

    public boolean getBoolean(String name) {
        return this.query.getBoolean((Object)name);
    }

    public Map<String, String> getKeyValues() {
        return this.query;
    }

    public Request getRequest() {
        return this.request;
    }

    public byte[] getPayload() {
        try {
            return InputStreams.readBytes(this.request.getInputStream());
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to read payload", e);
        }
    }
}

