/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.compilers;

import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

class CoffeeCompiler {
    private final Bindings CONTEXT;
    private final CompiledScript COFFEE_JS;

    public CoffeeCompiler() {
        ScriptEngine nashorn = new ScriptEngineManager().getEngineByName("nashorn");
        try (InputStreamReader reader = new InputStreamReader(ClassLoader.getSystemResourceAsStream("coffee/coffee-script.js"), StandardCharsets.UTF_8);){
            this.COFFEE_JS = ((Compilable)((Object)nashorn)).compile(reader);
            this.CONTEXT = nashorn.getBindings(100);
        }
        catch (IOException | ScriptException e) {
            throw new IllegalStateException(e);
        }
    }

    public synchronized String compile(String source) throws IOException {
        try {
            this.CONTEXT.put("coffeeScriptSource", (Object)source);
            return this.COFFEE_JS.eval(this.CONTEXT).toString();
        }
        catch (ScriptException e) {
            throw new IOException("Unable to compile coffee", e);
        }
    }
}

