/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.reload;

import com.sun.nio.file.SensitivityWatchEventModifier;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import net.codestory.http.Configuration;
import net.codestory.http.reload.RoutesProvider;
import net.codestory.http.routes.RouteCollection;

class ReloadingRoutesProvider
implements RoutesProvider {
    private final Configuration configuration;
    private RouteCollection routes;

    ReloadingRoutesProvider(Configuration configuration) {
        this.configuration = configuration;
        this.reload();
        this.startClassChangeWatcher(Paths.get("target/classes/", new String[0]));
    }

    @Override
    public synchronized RouteCollection get() {
        return this.routes;
    }

    private synchronized void reload() {
        System.out.println("Reloading configuration");
        this.routes = new RouteCollection();
        this.configuration.configure(this.routes);
        this.routes.addStaticRoutes(false);
    }

    private void startClassChangeWatcher(Path path) {
        new Thread(() -> {
            WatchService watchService;
            try {
                watchService = path.getFileSystem().newWatchService();
                Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attr) throws IOException {
                        dir.register(watchService, new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE}, SensitivityWatchEventModifier.HIGH);
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException iOException) {
                throw new IllegalStateException("Unable to watch folder " + path);
            }
            while (true) {
                try {
                    while (true) {
                        WatchKey watchKey = watchService.take();
                        boolean bl = false;
                        for (WatchEvent<?> watchEvent : watchKey.pollEvents()) {
                            bl = true;
                        }
                        watchKey.reset();
                        if (!bl) continue;
                        this.reload();
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }).start();
    }
}

