/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.compilers;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.markdown4j.Plugin;

public class FormulaPlugin
extends Plugin {
    public FormulaPlugin() {
        super("formula");
    }

    public void emit(StringBuilder out, List<String> lines, Map<String, String> params) {
        String type = params.getOrDefault("type", "png");
        for (String line : lines) {
            out.append("<img src=\"http://latex.codecogs.com/").append(type).append(".download?").append(FormulaPlugin.encode(line)).append("\" />");
        }
    }

    private static String encode(String line) {
        try {
            return URLEncoder.encode(line, StandardCharsets.US_ASCII.displayName());
        }
        catch (UnsupportedEncodingException e) {
            return line;
        }
    }
}

