/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.routes;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.ConcurrentHashMap;
import net.codestory.http.io.Resources;
import net.codestory.http.payload.Payload;
import net.codestory.http.routes.Match;
import net.codestory.http.routes.Route;
import org.simpleframework.http.Request;
import org.simpleframework.http.Response;

class StaticRoute
implements Route {
    private static final Path NOT_FOUND = Paths.get("", new String[0]);
    private final ConcurrentHashMap<String, Path> pathForUri = new ConcurrentHashMap(10);

    StaticRoute() {
    }

    @Override
    public Match apply(String uri, Request request, Response response) throws IOException {
        Path path = this.pathForUri.computeIfAbsent(uri, StaticRoute::findPath);
        if (path == NOT_FOUND) {
            if (!uri.endsWith("/") && StaticRoute.findPath(uri + "/") != null) {
                return Match.TRY_WITH_LEADING_SLASH;
            }
            return Match.WRONG_URL;
        }
        if (!"GET".equalsIgnoreCase(request.getMethod())) {
            return Match.WRONG_METHOD;
        }
        new Payload(path).writeTo(response);
        return Match.OK;
    }

    private static Path findPath(String uri) {
        Path path = Resources.findExistingPath(uri);
        return path != null && Resources.isPublic(path) ? path : NOT_FOUND;
    }
}

