/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.injection;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Singletons {
    private final Map<Class<?>, Object> singletons = new HashMap();

    public synchronized <T> T get(Class<T> type) {
        Object singleton = this.singletons.get(type);
        if (singleton != null) {
            return (T)singleton;
        }
        return this._get(type, new HashSet());
    }

    private <T> T _get(Class<T> type, Set<Class<?>> seenTypes) {
        if (!seenTypes.add(type)) {
            throw new IllegalStateException("Cycle in dependencies for " + type);
        }
        Object singleton = this.singletons.get(type);
        if (singleton != null) {
            return (T)singleton;
        }
        try {
            Constructor<T> constructor = Singletons.getConstructor(type);
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            Object[] parameters = new Object[parameterTypes.length];
            for (int i = 0; i < parameterTypes.length; ++i) {
                parameters[i] = this._get(parameterTypes[i], seenTypes);
            }
            T instance = this.postProcess(constructor.newInstance(parameters));
            this.singletons.put(type, instance);
            return instance;
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new IllegalStateException("Unable to create instance of " + type);
        }
    }

    protected <T> T postProcess(T instance) {
        return instance;
    }

    private static <T> Constructor<T> getConstructor(Class<T> type) {
        try {
            return type.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            Constructor<?>[] constructors = type.getConstructors();
            if (constructors.length != 1) {
                throw new IllegalStateException("Class " + type + " should have a single public constructor");
            }
            return constructors[0];
        }
    }
}

