/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.compilers;

import com.github.rjeschke.txtmark.BlockEmitter;
import com.github.rjeschke.txtmark.Configuration;
import com.github.rjeschke.txtmark.Decorator;
import com.github.rjeschke.txtmark.Processor;
import com.github.sommeri.less4j.Less4jException;
import com.github.sommeri.less4j.LessSource;
import com.github.sommeri.less4j.core.ThreadUnsafeLessCompiler;
import java.io.IOException;
import java.nio.file.Path;
import net.codestory.http.compilers.CoffeeCompiler;
import net.codestory.http.compilers.PathSource;
import org.markdown4j.CodeBlockEmitter;
import org.markdown4j.ExtDecorator;
import org.markdown4j.IncludePlugin;
import org.markdown4j.Plugin;
import org.markdown4j.TablePlugin;
import org.markdown4j.WebSequencePlugin;
import org.markdown4j.YumlPlugin;

public enum Compiler {
    COFFEE{

        @Override
        String doCompile(Path path, String coffee) throws IOException {
            return new CoffeeCompiler().compile(coffee);
        }
    }
    ,
    MARKDOWN{

        @Override
        String doCompile(Path path, String markdown) throws IOException {
            Configuration.Builder builder = Configuration.builder().forceExtentedProfile().registerPlugins(new Plugin[]{new TablePlugin(), new YumlPlugin(), new WebSequencePlugin(), new IncludePlugin()}).setDecorator((Decorator)new ExtDecorator()).setCodeBlockEmitter((BlockEmitter)new CodeBlockEmitter());
            return Processor.process((String)markdown, (Configuration)builder.build());
        }
    }
    ,
    LESS{

        @Override
        String doCompile(Path path, String less) throws IOException {
            try {
                return new ThreadUnsafeLessCompiler().compile((LessSource)new PathSource(path, less)).getCss();
            }
            catch (Less4jException e) {
                throw new IOException("Unable to compile less", e);
            }
        }
    }
    ,
    LESS_MAP{

        @Override
        String doCompile(Path path, String less) throws IOException {
            try {
                return new ThreadUnsafeLessCompiler().compile((LessSource)new PathSource(path, less)).getSourceMap();
            }
            catch (Less4jException e) {
                throw new IOException("Unable to compile less", e);
            }
        }
    }
    ,
    NONE{

        @Override
        String doCompile(Path path, String content) {
            return content;
        }
    };


    abstract String doCompile(Path var1, String var2) throws IOException;

    public static String compile(Path path, String content) throws IOException {
        return Compiler.compilerForPath(path).doCompile(path, content);
    }

    private static Compiler compilerForPath(Path path) {
        String name = path.toString();
        if (name.endsWith(".less")) {
            return LESS;
        }
        if (name.endsWith(".css.map")) {
            return LESS_MAP;
        }
        if (name.endsWith(".coffee")) {
            return COFFEE;
        }
        if (name.endsWith(".md") || name.endsWith(".markdown")) {
            return MARKDOWN;
        }
        return NONE;
    }
}

