/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.ssl;

import java.io.ByteArrayInputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.PKCS8EncodedKeySpec;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;

public class SSLContextFactory {
    public SSLContext create(Path pathCertificate, Path pathPrivateKey) throws Exception {
        X509Certificate cert = SSLContextFactory.generateCertificateFromDER(Files.readAllBytes(pathCertificate));
        RSAPrivateKey key = SSLContextFactory.generatePrivateKeyFromDER(Files.readAllBytes(pathPrivateKey));
        KeyStore keystore = KeyStore.getInstance("JKS");
        keystore.load(null);
        keystore.setCertificateEntry("cert-alias", cert);
        keystore.setKeyEntry("key-alias", key, new char[0], new X509Certificate[]{cert});
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(SSLContextFactory.getKeyManagers(keystore), null, null);
        return context;
    }

    private static KeyManager[] getKeyManagers(KeyStore keyStore) throws Exception {
        KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
        kmf.init(keyStore, new char[0]);
        return kmf.getKeyManagers();
    }

    private static X509Certificate generateCertificateFromDER(byte[] data) throws Exception {
        return (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(data));
    }

    private static RSAPrivateKey generatePrivateKeyFromDER(byte[] data) throws Exception {
        return (RSAPrivateKey)KeyFactory.getInstance("RSA").generatePrivate(new PKCS8EncodedKeySpec(data));
    }
}

