/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.routes;

import java.io.IOException;
import java.util.Map;
import net.codestory.http.internal.UriParser;
import net.codestory.http.payload.Payload;
import net.codestory.http.routes.Match;
import net.codestory.http.routes.Route;
import net.codestory.http.templating.Model;
import net.codestory.http.templating.Template;
import org.simpleframework.http.Request;
import org.simpleframework.http.Response;

abstract class AbstractRouteWrapper
implements Route {
    private final String method;
    private final UriParser uriParser;

    protected AbstractRouteWrapper(String method, String uriPattern) {
        this.method = method;
        this.uriParser = new UriParser(uriPattern);
    }

    @Override
    public Match apply(String uri, Request request, Response response) throws IOException {
        if (!this.uriParser.matches(uri)) {
            return Match.WRONG_URL;
        }
        if (!this.method.equalsIgnoreCase(request.getMethod())) {
            return Match.WRONG_METHOD;
        }
        String[] parameters = this.uriParser.params(uri, (Map<String, String>)request.getQuery());
        Object body = this.body(request, parameters);
        if (body instanceof Model) {
            body = new Template(uri).render((Model)body);
        }
        Payload payload = Payload.wrap(body);
        payload.writeTo(response);
        return Match.OK;
    }

    protected abstract Object body(Request var1, String[] var2);
}

