/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.templating;

import com.github.jknack.handlebars.Context;
import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.ValueResolver;
import com.github.jknack.handlebars.cache.ConcurrentMapTemplateCache;
import com.github.jknack.handlebars.cache.TemplateCache;
import com.github.jknack.handlebars.context.FieldValueResolver;
import com.github.jknack.handlebars.context.JavaBeanValueResolver;
import com.github.jknack.handlebars.context.MapValueResolver;
import com.github.jknack.handlebars.helper.StringHelpers;
import com.github.jknack.handlebars.io.AbstractTemplateLoader;
import com.github.jknack.handlebars.io.StringTemplateSource;
import com.github.jknack.handlebars.io.TemplateLoader;
import com.github.jknack.handlebars.io.TemplateSource;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import net.codestory.http.io.Resources;
import net.codestory.http.templating.Site;
import net.codestory.http.templating.helpers.EachReverseHelperSource;
import net.codestory.http.templating.helpers.EachValueHelperSource;

public enum HandlebarsCompiler {
    INSTANCE;

    private final Handlebars handlebars = HandlebarsCompiler.handlebars();

    public String compile(String template, Map<String, Object> variables) throws IOException {
        return this.handlebars.compileInline(template).apply(HandlebarsCompiler.context(variables));
    }

    private static Handlebars handlebars() {
        return new Handlebars().startDelimiter("[[").endDelimiter("]]").registerHelpers((Object)new EachReverseHelperSource()).registerHelpers((Object)new EachValueHelperSource()).registerHelpers(StringHelpers.class).with((TemplateCache)new ConcurrentMapTemplateCache()).with(new TemplateLoader[]{new AbstractTemplateLoader(){

            public TemplateSource sourceAt(String location) throws IOException {
                return new StringTemplateSource(location, Resources.read(Resources.findExistingPath("_includes/" + location), StandardCharsets.UTF_8));
            }
        }});
    }

    private static Context context(Map<String, Object> variables) {
        return Context.newBuilder(null).resolver(new ValueResolver[]{MapValueResolver.INSTANCE, JavaBeanValueResolver.INSTANCE, FieldValueResolver.INSTANCE, Site.SiteValueResolver.INSTANCE}).combine("site", (Object)Site.get()).combine(variables).build();
    }
}

