/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.compilers;

import com.github.sommeri.less4j.LessSource;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.codestory.http.io.Resources;

class PathSource
extends LessSource {
    private final Path path;
    private final String content;

    PathSource(Path path, String content) {
        this.path = path;
        this.content = content;
    }

    public LessSource relativeSource(String filename) throws LessSource.CannotReadFile, LessSource.FileNotFound {
        String includeContent;
        Path relativePath = Paths.get(filename, new String[0]);
        if (!Resources.exists(relativePath)) {
            throw new LessSource.FileNotFound();
        }
        try {
            includeContent = Resources.read(relativePath, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new LessSource.CannotReadFile();
        }
        return new PathSource(relativePath, includeContent);
    }

    public String getName() {
        return this.path.toString();
    }

    public String getContent() {
        return this.content;
    }
}

