/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.templating;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import net.codestory.http.io.Resources;
import net.codestory.http.templating.YamlFrontMatter;
import net.codestory.http.templating.YamlParser;

public class Site {
    private static Site INSTANCE = new Site();
    private Map<String, Object> yaml;
    private Map<String, List<Map<String, Object>>> tags;
    private Map<String, List<Map<String, Object>>> categories;
    private List<Map<String, Object>> pages;

    private Site() {
    }

    public static Site get() {
        if (Boolean.getBoolean("PROD_MODE")) {
            return INSTANCE;
        }
        return new Site();
    }

    public Map<String, List<Map<String, Object>>> getTags() {
        if (this.tags == null) {
            this.tags = new TreeMap<String, List<Map<String, Object>>>();
            for (Map<String, Object> page : this.getPages()) {
                for (String tag : Site.tags(page)) {
                    this.tags.computeIfAbsent(tag, string -> new ArrayList()).add(page);
                }
            }
        }
        return this.tags;
    }

    public Map<String, List<Map<String, Object>>> getCategories() {
        if (this.categories == null) {
            Map<String, List<Map>> notSorted = this.getPages().stream().collect(Collectors.groupingBy(Site::category));
            this.categories = new TreeMap<String, List<Map>>(notSorted);
        }
        return this.categories;
    }

    public List<Map<String, Object>> getPages() {
        if (this.pages == null) {
            this.pages = Resources.list().stream().map(Site::pathToMap).collect(Collectors.toList());
        }
        return this.pages;
    }

    private static Map<String, Object> pathToMap(String path) {
        try {
            return YamlFrontMatter.parse(Paths.get(path, new String[0])).getVariables();
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to read file: " + path, e);
        }
    }

    private static String category(Map<String, Object> page) {
        return page.getOrDefault("category", "").toString().trim();
    }

    private static String[] tags(Map<String, Object> page) {
        return page.getOrDefault("tags", "").toString().trim().split("\\s*,\\s*");
    }

    Map<String, Object> configYaml() {
        if (this.yaml == null) {
            this.yaml = this.loadYamlConfig("_config.yml");
        }
        return this.yaml;
    }

    private Map<String, Object> loadYamlConfig(String configFile) {
        Path configPath = Paths.get(configFile, new String[0]);
        if (!Resources.exists(configPath)) {
            return new HashMap<String, Object>();
        }
        try {
            return new YamlParser().parse(Resources.read(configPath, StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to read " + configFile, e);
        }
    }
}

