/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.routes;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.codestory.http.Payload;
import net.codestory.http.io.Resources;
import net.codestory.http.routes.Match;
import net.codestory.http.routes.Route;
import net.codestory.http.types.ContentTypes;

class StaticRoute
implements Route {
    StaticRoute() {
    }

    @Override
    public Match apply(String uri, HttpExchange exchange) throws IOException {
        if (uri.endsWith("/")) {
            return this.apply(uri + "index", exchange);
        }
        for (String extension : ContentTypes.TEMPLATE_EXTENSIONS) {
            Match match = this.serve(Paths.get(uri + extension, new String[0]), exchange);
            if (Match.WRONG_URL == match) continue;
            return match;
        }
        return Match.WRONG_URL;
    }

    private Match serve(Path path, HttpExchange exchange) throws IOException {
        for (Path part : path) {
            if (!part.toString().equals("..") && !part.toString().startsWith("_")) continue;
            return Match.WRONG_URL;
        }
        if (!Resources.exists(path)) {
            return Match.WRONG_URL;
        }
        if (!"GET".equalsIgnoreCase(exchange.getRequestMethod())) {
            return Match.WRONG_METHOD;
        }
        new Payload(path).writeTo(exchange);
        return Match.OK;
    }
}

