/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.routes;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import net.codestory.http.Payload;
import net.codestory.http.UriParser;
import net.codestory.http.routes.AnyRoute;
import net.codestory.http.routes.Match;
import net.codestory.http.routes.Route;

class RouteWrapper
implements Route {
    private final String method;
    private final UriParser uriParser;
    private final AnyRoute route;

    RouteWrapper(String method, String uriPattern, AnyRoute route) {
        this.method = method;
        this.uriParser = new UriParser(uriPattern);
        this.route = route;
    }

    @Override
    public Match apply(String uri, HttpExchange exchange) throws IOException {
        if (!this.uriParser.matches(uri)) {
            return Match.WRONG_URL;
        }
        if (!this.method.equalsIgnoreCase(exchange.getRequestMethod())) {
            return Match.WRONG_METHOD;
        }
        String[] parameters = this.uriParser.params(uri);
        Object body = this.route.body(parameters);
        Payload payload = Payload.wrap(body);
        payload.writeTo(exchange);
        return Match.OK;
    }
}

