/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.routes;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import net.codestory.http.Payload;
import net.codestory.http.UriParser;
import net.codestory.http.annotations.Get;
import net.codestory.http.annotations.Post;
import net.codestory.http.filters.Filter;
import net.codestory.http.routes.AnyRoute;
import net.codestory.http.routes.FourParamsRoute;
import net.codestory.http.routes.Match;
import net.codestory.http.routes.NoParamRoute;
import net.codestory.http.routes.OneParamRoute;
import net.codestory.http.routes.ReflectionRoute;
import net.codestory.http.routes.Route;
import net.codestory.http.routes.RouteWrapper;
import net.codestory.http.routes.Routes;
import net.codestory.http.routes.StaticRoute;
import net.codestory.http.routes.ThreeParamsRoute;
import net.codestory.http.routes.TwoParamsRoute;

public class RouteCollection
implements Routes {
    private final Deque<Route> routes = new LinkedList<Route>();
    private final Deque<Filter> filters = new LinkedList<Filter>();

    @Override
    public void add(Object resource) {
        this.add("", resource);
    }

    @Override
    public void add(String urlPrefix, Object resource) {
        Class<?> type = resource.getClass();
        if (resource.getClass().getName().contains("EnhancerByMockito")) {
            type = type.getSuperclass();
        }
        for (Method method : type.getMethods()) {
            String uriPattern;
            int parameterCount = method.getParameterCount();
            for (Get get : (Get[])method.getDeclaredAnnotationsByType(Get.class)) {
                uriPattern = urlPrefix + get.value();
                this.add("GET", RouteCollection.checkParametersCount(uriPattern, parameterCount), new ReflectionRoute(resource, method));
            }
            for (Annotation annotation : (Post[])method.getDeclaredAnnotationsByType(Post.class)) {
                uriPattern = urlPrefix + annotation.value();
                this.add("POST", RouteCollection.checkParametersCount(uriPattern, parameterCount), new ReflectionRoute(resource, method));
            }
        }
    }

    @Override
    public void get(String uriPattern, Payload payload) {
        this.get(uriPattern, () -> payload);
    }

    @Override
    public void get(String uriPattern, NoParamRoute noParamRoute) {
        this.add("GET", RouteCollection.checkParametersCount(uriPattern, 0), noParamRoute);
    }

    @Override
    public void get(String uriPattern, OneParamRoute route) {
        this.add("GET", RouteCollection.checkParametersCount(uriPattern, 1), route);
    }

    @Override
    public void get(String uriPattern, TwoParamsRoute route) {
        this.add("GET", RouteCollection.checkParametersCount(uriPattern, 2), route);
    }

    @Override
    public void get(String uriPattern, ThreeParamsRoute route) {
        this.add("GET", RouteCollection.checkParametersCount(uriPattern, 3), route);
    }

    @Override
    public void get(String uriPattern, FourParamsRoute route) {
        this.add("GET", RouteCollection.checkParametersCount(uriPattern, 4), route);
    }

    @Override
    public void post(String uriPattern, NoParamRoute noParamRoute) {
        this.add("POST", RouteCollection.checkParametersCount(uriPattern, 0), noParamRoute);
    }

    @Override
    public void post(String uriPattern, OneParamRoute route) {
        this.add("POST", RouteCollection.checkParametersCount(uriPattern, 1), route);
    }

    @Override
    public void post(String uriPattern, TwoParamsRoute route) {
        this.add("POST", RouteCollection.checkParametersCount(uriPattern, 2), route);
    }

    @Override
    public void post(String uriPattern, ThreeParamsRoute route) {
        this.add("POST", RouteCollection.checkParametersCount(uriPattern, 3), route);
    }

    @Override
    public void post(String uriPattern, FourParamsRoute route) {
        this.add("POST", RouteCollection.checkParametersCount(uriPattern, 4), route);
    }

    @Override
    public void filter(Filter filter) {
        this.filters.addLast(filter);
    }

    public void reset() {
        this.routes.clear();
        this.filters.clear();
    }

    private void add(String method, String uriPattern, AnyRoute route) {
        this.routes.addFirst(new RouteWrapper(method, uriPattern, route));
    }

    public Match apply(HttpExchange exchange) throws IOException {
        String uri = exchange.getRequestURI().getPath();
        for (Filter filter : this.filters) {
            if (!filter.apply(uri, exchange)) continue;
            return Match.OK;
        }
        Match bestMatch = Match.WRONG_URL;
        ArrayList<Route> allRoutes = new ArrayList<Route>();
        allRoutes.addAll(this.routes);
        allRoutes.add(new StaticRoute());
        for (Route route : allRoutes) {
            Match match = route.apply(uri, exchange);
            if (match == Match.OK) {
                return Match.OK;
            }
            if (!match.isBetter(bestMatch)) continue;
            bestMatch = match;
        }
        return bestMatch;
    }

    private static String checkParametersCount(String uriPattern, int count) {
        if (UriParser.paramsCount(uriPattern) != count) {
            throw new IllegalArgumentException("Expected " + count + " parameters in " + uriPattern);
        }
        return uriPattern;
    }
}

