/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.routes;

import java.lang.reflect.Method;
import net.codestory.http.routes.AnyRoute;

class ReflectionRoute
implements AnyRoute {
    private final Object resource;
    private final Method method;

    ReflectionRoute(Object resource, Method method) {
        this.resource = resource;
        this.method = method;
    }

    @Override
    public Object body(String[] parameters) {
        try {
            Object[] arguments = ReflectionRoute.convert(parameters, this.method.getParameterTypes());
            this.method.setAccessible(true);
            return this.method.invoke(this.resource, arguments);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to apply resource", e);
        }
    }

    private static Object[] convert(String[] values, Class<?>[] types) {
        Object[] converted = new Object[values.length];
        for (int i = 0; i < values.length; ++i) {
            converted[i] = ReflectionRoute.convert(values[i], types[i]);
        }
        return converted;
    }

    static Object convert(String value, Class<?> type) {
        if (type == Integer.TYPE || type == Integer.class) {
            return Integer.parseInt(value);
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            return Boolean.parseBoolean(value);
        }
        return value;
    }
}

